#include "mbed.h"
#include "TextLCD.h"
#include "rtos.h"

TextLCD lcd(p24, p26, p27, p28, p29, p30); // rs, e, d4-d7
AnalogIn ain(p20);
DigitalOut led(LED1);

float Temp;

void display(void const *n)
{
    static int num=0;
    lcd.locate(0,0);
    lcd.printf("Count %3d",num);
    lcd.locate(0,1);
    lcd.printf("Temp=%4.1f",Temp);
    num++;
    if(num>999)num=0;
}

void measure(void const *n)
{
    Temp=ain.read()*3.3*100;
    led=!led;
}

int main()
{
    led=0;
    lcd.cls();
    RtosTimer measure_timer(measure);
    RtosTimer display_timer(display);
    measure_timer.start(2000);
    display_timer.start(3000);
    Thread::wait(osWaitForever);
}
