//#define DNS_SERVER_ADDRESS(ipaddr)        (ip4_addr_set_u32(ipaddr, ipaddr_addr("208.67.222.222"))) /* resolver1.opendns.com */
#include "mbed.h"
#include "rtos.h"
#include "EthernetInterface.h"
#include "HTTPServer.h"
#include "mbed_rpc.h"
#include "TextLCD.h"

EthernetInterface eth;
LocalFileSystem local("local");
DigitalOut led4(LED4);

DigitalOut led1(LED1);
AnalogIn ain(p20);

TextLCD lcd(p24, p26, p27, p28, p29, p30);

float Temp;

void LcdWrite(Arguments* arg, Reply* r);void LcdWrite(Arguments* arg, Reply* r);
void aliveState(void const *args)
{
    while (true) {
        led4 = !led4;
        Thread::wait(1000);
    }
}

void measure(void const *n)
{
    Temp=ain.read()*3.3*100;
    led1=!led1;
}

int main()
{
    printf("********* PROGRAM START ***********\r\n");
    Thread thread(aliveState);
    
    led1=0;
    RtosTimer measure_timer(measure);
    measure_timer.start(2000);
    
    lcd.cls();
    lcd.locate(0,0);
    
    printf("********* RPC Initialize ***********\r\n");
    RPC::add_rpc_class<RpcDigitalOut>();
    RPC::construct<RpcDigitalOut, PinName, const char*>(LED1, "led1");
    RPC::construct<RpcDigitalOut, PinName, const char*>(LED2, "led2");
    RPC::construct<RpcDigitalOut, PinName, const char*>(LED3, "led3");
    RPCFunction rpcFunc(LcdWrite, "LcdWrite"); 
    RPCVariable <float>rpcval(&Temp,"temp");
    printf("EthernetInterface Setting up...\r\n");
    if(eth.init()!=0) {                             //for DHCP Server
       // if(eth.init("133.11.168.23","255.255.255.0","133.11.168.1")!=0) { //for Static IP Address
        printf("EthernetInterface Initialize Error \r\n");
        return -1;
    }
    if(eth.connect()!=0) {
        printf("EthernetInterface Connect Error \r\n");
        return -1;
    }
    printf("IP Address is %s\r\n", eth.getIPAddress());
    printf("NetMask is %s\r\n", eth.getNetworkMask());
    printf("Gateway Address is %s\r\n", eth.getGateway());
    printf("Ethernet Setup OK\r\n");

    FSHandler::mount("/local","/");
    
    lcd.locate(0,0);
    lcd.printf("%s",eth.getIPAddress());
    HTTPServerStart(80);
}

void LcdWrite(Arguments* arg, Reply* r)  //RPC Call
{
    lcd.locate(0,1);
    lcd.printf("%s",arg->argv[0]);
}

