//#define DNS_SERVER_ADDRESS(ipaddr)        (ip4_addr_set_u32(ipaddr, ipaddr_addr("208.67.222.222"))) /* resolver1.opendns.com */
#include "mbed.h"
#include "rtos.h"
#include "EthernetInterface.h"
#include "HTTPServer.h"
#include "mbed_rpc.h"
#include "TextLCD.h"

EthernetInterface eth;

DigitalOut led4(LED4);

LocalFileSystem local("local");
void LcdWrite(Arguments* arg, Reply* r);    //ADD Here!!

TextLCD lcd(p24, p26, p27, p28, p29, p30);

void aliveState(void const *args)
{
    while (true) {
        led4 = !led4;
        Thread::wait(1000);
    }
}

int main()
{
    printf("********* PROGRAM START ***********\r\n");
    Thread thread(aliveState);
    RPC::add_rpc_class<RpcDigitalOut>();
    RPC::construct<RpcDigitalOut, PinName, const char*>(LED1, "led1");
    RPC::construct<RpcDigitalOut, PinName, const char*>(LED2, "led2");
    RPC::construct<RpcDigitalOut, PinName, const char*>(LED3, "led3");
    RPCFunction rpcFunc(LcdWrite, "LcdWrite"); //ADD Here!!
    lcd.cls();
    lcd.locate(0,0);

    printf("EthernetInterface Setting up...\r\n");
    if(eth.init()!=0) {                             //for DHCP Server
        //if(eth.init(IPAddress,NetMasks,Gateway)!=0) { //for Static IP Address
        printf("EthernetInterface Initialize Error \r\n");
        return -1;
    }
    if(eth.connect()!=0) {
        printf("EthernetInterface Connect Error \r\n");
        return -1;
    }
    printf("IP Address is %s\r\n", eth.getIPAddress());
    printf("NetMask is %s\r\n", eth.getNetworkMask());
    printf("Gateway Address is %s\r\n", eth.getGateway());
    printf("Ethernet Setup OK\r\n");

    HTTPServerAddHandler<SimpleHandler>("/hello"); //Default handler
    FSHandler::mount("/local", "/");
    HTTPServerAddHandler<FSHandler>("/");
    HTTPServerAddHandler<RPCHandler>("/rpc");
    lcd.locate(0,0);
    lcd.printf("%s",eth.getIPAddress());
    HTTPServerStart(80);
}

void LcdWrite(Arguments* arg, Reply* r)  //ADD Here!!
{
    lcd.locate(0,1);
    lcd.printf("%s",arg->argv[0]);
}
