#include "fiap.h"
#include "mbed.h"
#include "stdio.h"
#include "spdomparser.hpp"
#include "spxmlnode.hpp"
#include "spxmlhandle.hpp"

char outBuffer[2000+1]= {0};
char _soap_text[2000];
char uuid[37];
//    HTTPClient http;
//    HTTPText InData("text/html", 800);
//    HTTPStream stream;
//char str[50];
//int yy,mo,dd,hh,mm,ss;
//char requestBuffer[50];
//int i,ii,ll;
//HTTPResult r;
//FIAP::FIAP(string Storage,string PointSetId) {

void FIAP::post_xml_initialize(void)
{
    strcpy(_soap_header,"<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
    strcat(_soap_header,"<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\">");
    strcat(_soap_header,"<soapenv:Body>");
    strcat(_soap_header,"<ns2:dataRQ xmlns:ns2=\"http://soap.fiap.org/\">");
    strcat(_soap_header,"<transport xmlns=\"http://gutp.jp/fiap/2009/11/\">");
    strcat(_soap_header,"<body>");
    strcpy(_soap_footer,"</body>");
    strcat(_soap_footer,"</transport>");
    strcat(_soap_footer,"</ns2:dataRQ>");
    strcat(_soap_footer,"</soapenv:Body>");
    strcat(_soap_footer,"</soapenv:Envelope>");
    strcat(_soap_footer,"\r\n\r\n");
    strcpy(_soap_action,"\"http://soap.fiap.org/data\"");
}
void FIAP::fetch_xml_initialize(void)
{
    strcpy(_soap_header,"<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
    strcat(_soap_header,"<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\">");
    strcat(_soap_header,"<soapenv:Body>");
    strcat(_soap_header,"<ns2:queryRQ xmlns:ns2=\"http://soap.fiap.org/\">");
    strcat(_soap_header,"<transport xmlns=\"http://gutp.jp/fiap/2009/11/\">");
    strcat(_soap_header,"<header>");
    strcpy(_soap_footer,"</header>");
    strcat(_soap_footer,"</transport>");
    strcat(_soap_footer,"</ns2:queryRQ>");
    strcat(_soap_footer,"</soapenv:Body>");
    strcat(_soap_footer,"</soapenv:Envelope>");
    strcat(_soap_footer,"\r\n\r\n");
    strcpy(_soap_action,"\"http://soap.fiap.org/query\"");
}

FIAP::FIAP(char Storage[])
{
    debug_mode=false;
    strcpy(_fiap_storage,Storage);
}

int FIAP::fetch_last_data(struct fiap_element* v,unsigned int esize)
{
    HTTPClient http;
    int i,ii,ll,k1,k2;
    fetch_xml_initialize();
    strcpy( _soap_text, _soap_header);
    sprintf(uuid,"%04x%04x-%04x-%04x-%04x-%04x%04x%04x",rand()%0x10000,rand()%0x10000,rand()%0x10000,rand()%1000|0x4000,rand()%0x1000|0x8000,rand()%0x10000,rand()%10000,(rand()+1)%0x10000);
    strcat( _soap_text , "<query id=\"");
    strcat( _soap_text , uuid);
    strcat( _soap_text , "\" type=\"storage\">");
    for (i=0; i<esize; i++) {
        strcat(_soap_text , "<key id=\"");
        strcat(_soap_text , v[i].cid);
        strcat(_soap_text , "\" attrName=\"time\" select=\"maximum\"/>");
    }
    strcat(_soap_text , "</query>");
    strcat(_soap_text , _soap_footer);
    if (debug_mode) {
        printf(_fiap_storage);
        printf("\r\n");
        printf(_soap_text);
        printf("<<< Request(end)\n");
    }
    //HTTPText InData("text/html", 800);
    //InData.set(_soap_text);
    HTTPText InData(_soap_text);
    char rstr[800];
    HTTPText stream(rstr,800);
    //stream.readNext((byte*)outBuffer,1500);
    if (debug_mode)printf("post.start \n\r");
    HTTPResult r = http.postXML(_fiap_storage,"http://soap.fiap.org/query",InData,&stream);
    if (debug_mode) printf("post.end \n\r");
    if (debug_mode) {
        printf("****\n\r");
        printf(rstr);
        printf("\n\r****\n\r");
    }
    if(!r) {
        if (debug_mode)printf("Success \n");
    } else {

        if (r==HTTP_PROCESSING) {
            if (debug_mode)printf("Processing \n");
            return -1;
        }
        if (r==HTTP_PARSE) {
            if (debug_mode) printf("URI Parse error \n");
            return -1;
        }
        if (r==HTTP_DNS) {
            if (debug_mode) printf("Could not resolve name\n");
            return -1;
        }
        if (r==HTTP_PRTCL) {
            if (debug_mode)printf("Protocol error\n");
            return -1;
        }
        if (r==HTTP_NOTFOUND) {
            if (debug_mode)printf("HTTP 404 Error\n");
            return -1;
        }
        if (r==HTTP_REFUSED) {
            if (debug_mode) printf("HTTP 403 Error \n");
            return -1;
        }
        if (r==HTTP_ERROR) {
            if (debug_mode)printf("HTTP xxx error %d  \n ",r);
            return -1;
        }
        if (r==HTTP_TIMEOUT) {
            if (debug_mode)printf("Connection timeout\n");
            return -1;
        }
        if (r==HTTP_CONN) {
            if (debug_mode)printf("Connection error\n");
            return -1;
        }
        if (r==HTTP_CLOSED) {
            if (debug_mode)printf("Connection error\n");
            return -1;
        }
        if (debug_mode)printf("Unknown Network Error\n");
        return -1;
    }
    SP_XmlNodeList * points;
    SP_XmlNodeList * trans_point;
    if (strlen(rstr)>0) {
        if (debug_mode)printf("\n\r data Get Ok\n\r");
        SP_XmlDomParser parser;
        parser.append(rstr,strlen(rstr));
        //stream.readNext((byte*)outBuffer,4096);
        SP_XmlHandle rootHandle(parser.getDocument()->getRootElement());
        SP_XmlHandle transport = rootHandle.getChild(0).getChild(0).getChild(0);
        SP_XmlElementNode * fiapError = transport.getChild("header").getChild("error").toElement();
        int yy,mo,dd,hh,mm,ss;
        char str[50];
        if (debug_mode) printf ("%s \n",transport.toElement()->getName());
        if (fiapError==NULL) {
            SP_XmlElementNode * trans_element = transport.toElement();
            trans_point=(SP_XmlNodeList *)trans_element->getChildren() ;
            k1=trans_point->getLength();
            if(debug_mode)printf("Trans Child has Element of No %d \n\r",k1);
            SP_XmlElementNode * values;
            for(k2=0; k2<k1; k2++) {
                values =transport.getChild(k2).toElement();
                if(debug_mode)printf(values->getName());
                if(debug_mode)printf("\n\r");
                if(strstr((values->getName()),"body") !=NULL) {
                    if(debug_mode)printf("find body \n\r");
                    points=(SP_XmlNodeList *)values->getChildren() ;
                    int j=points->getLength();
                    if (debug_mode)    printf("GetValues of No %d \n\r",j);
                    SP_XmlElementNode *data_point_node,*data_value_node;
                    SP_XmlCDataNode *data_value_cnode;
                    for (i=0; i<j; i++) {
                        SP_XmlHandle data_handle(points->get(i));//Point
                        data_point_node=data_handle.toElement();
                        //data_value_node=data_handle.getChild("value").toElement();
                        //data_value_cnode=data_handle.getChild("value").getChild(0).toCData();
                        data_value_node=data_handle.getChild(0).toElement();
                        data_value_cnode=data_handle.getChild(0).getChild(0).toCData();
                        if (debug_mode)         printf("PointID=%s \r\n",data_point_node->getAttrValue("id"));
                        if (debug_mode)         printf("date=%s \r\n",data_value_node->getAttrValue("time"));
                        if (debug_mode)         printf("data=%s \r\n",data_value_cnode->getText());
                        for (ii=0; ii<esize; ii++) {
                            if (strcmp(v[ii].cid,data_point_node->getAttrValue("id"))==0) {
                                sprintf(str,"%s",data_value_node->getAttrValue("time"));
                                ll=sscanf(str,"%d-%d-%dT%d:%d:%d.",&yy,&mo,&dd,&hh,&mm,&ss);
                                if (debug_mode)printf("date convert no %d (%d/%d/%d %d:%d:%d) \r\n",ll,yy,mo,dd,hh,mm,ss);
                                v[ii].year=yy;
                                v[ii].month=mo;
                                v[ii].day=dd;
                                v[ii].hour=hh;
                                v[ii].minute=mm;
                                v[ii].second=ss;
                                sprintf(v[ii].value,"%s",data_value_cnode->getText());
                            }
                        }
                    }

                }


            }

        } else {
            printf("ERROR\n\r");
        }
    } else {
        if (debug_mode)printf("error\n\r");
    }
    return 0;
}

int FIAP::fetch_last_data(struct fiap_element *v)
{
    HTTPClient http;
    int ll;
    char rstr[800];
    fetch_xml_initialize();
    strcpy(_soap_text, _soap_header);
    sprintf(uuid,"%04x%04x-%04x-%04x-%04x-%04x%04x%04x",rand()%0x10000,rand()%0x10000,rand()%0x10000,rand()%1000|0x4000,rand()%0x1000|0x8000,rand()%0x10000,rand()%10000,(rand()+1)%0x10000);
    strcat(_soap_text , "<query id=\"");
    strcat(_soap_text , uuid);
    strcat(_soap_text , "\" type=\"storage\">");
    strcat(_soap_text , "<key id=\"");
    strcat(_soap_text , v->cid);
    strcat(_soap_text , "\" attrName=\"time\" select=\"maximum\"/>");
    strcat(_soap_text , "</query>");
    strcat(_soap_text , _soap_footer);
    if (debug_mode) {
        printf("\r\n");
        printf(_fiap_storage);
        printf("\r\n");
        printf(_soap_text);
        printf("<<< Request(end)\n");
    }
//    http.setRequestHeader("Content-Type","text/xml; charset=UTF-8");
//    http.setRequestHeader("SOAPAction","\"http://soap.fiap.org/query\"");
    HTTPText InData(_soap_text);
    HTTPText stream(rstr,800);
//    stream.readNext((byte*)outBuffer,strlen(outBuffer));
    if (debug_mode)printf("post.start \n\r");
    HTTPResult r = http.postXML(_fiap_storage,"http://soap.fiap.org/query",InData,&stream);
    if (debug_mode)printf("post.end \n\r");
    if(!r) {
        if (debug_mode)printf("Success \n");
    } else {
        if (r==HTTP_PROCESSING) {
            if (debug_mode)printf("Processing \n");
            return -1;
        }
        if (r==HTTP_PARSE) {
            if (debug_mode) printf("URI Parse error \n");
            return -1;
        }
        if (r==HTTP_DNS) {
            if (debug_mode) printf("Could not resolve name\n");
            return -1;
        }
        if (r==HTTP_PRTCL) {
            if (debug_mode)printf("Protocol error\n");
            return -1;
        }
        if (r==HTTP_NOTFOUND) {
            if (debug_mode)printf("HTTP 404 Error\n");
            return -1;
        }
        if (r==HTTP_REFUSED) {
            if (debug_mode) printf("HTTP 403 Error \n");
            return -1;
        }
        if (r==HTTP_ERROR) {
            if (debug_mode)printf("HTTP xxx error %d  \n ",r);
            return -1;
        }
        if (r==HTTP_TIMEOUT) {
            if (debug_mode)printf("Connection timeout\n");
            return -1;
        }
        if (r==HTTP_CONN) {
            if (debug_mode)printf("Connection error\n");
            return -1;
        }
        if (r==HTTP_CLOSED) {
            if (debug_mode)printf("Connection error\n");
            return -1;
        }
        if (debug_mode)printf("Unknown Network Error\n");
        return -1;
    }
    SP_XmlNodeList * points;
    if (strlen(rstr)>0) {
        if (debug_mode)printf("\n\r data Get Ok\n\r");

        SP_XmlDomParser parser;

        // if (debug_mode)printf("stream readlen = %d \n\r",stream.readLen());
        // outBuffer[stream.readLen()]=0;
        if (debug_mode)printf("check0\n\r");
        parser.append(rstr,strlen(rstr));
        if (debug_mode)printf("check1\n\r");
        SP_XmlHandle rootHandle(parser.getDocument()->getRootElement());
        SP_XmlHandle transport = rootHandle.getChild(0).getChild(0).getChild(0);
        SP_XmlElementNode * fiapError = transport.getChild("header").getChild("error").toElement();
        int yy,mo,dd,hh,mm,ss;
        char str[50];
        if (debug_mode)printf ("%s \n\r",transport.toElement()->getName());
        if (fiapError==NULL) {
            SP_XmlElementNode * values =transport.getChild("body").toElement();
            points=(SP_XmlNodeList *)values->getChildren() ;
            //      points=values->getChildren();
            int j=points->getLength();
            if (debug_mode)    printf("GetValues of No %d \n\r",j);
            SP_XmlElementNode *data_point_node,*data_value_node;
            SP_XmlCDataNode *data_value_cnode;
            SP_XmlHandle data_handle(points->get(0));//Point
            data_point_node=data_handle.toElement();
            data_value_node=data_handle.getChild("value").toElement();
            data_value_cnode=data_handle.getChild("value").getChild(0).toCData();
            if (debug_mode)         printf("PointID=%s \r\n",data_point_node->getAttrValue("id"));
            if (debug_mode)         printf("date=%s \r\n",data_value_node->getAttrValue("time"));
            if (debug_mode)         printf("data=%s \r\n",data_value_cnode->getText());
            sprintf(str,"%s",data_value_node->getAttrValue("time"));
            ll=sscanf(str,"%d-%d-%dT%d:%d:%d.",&yy,&mo,&dd,&hh,&mm,&ss);
            if (debug_mode)printf("date convert no %d (%d/%d/%d %d:%d:%d) \r\n",ll,yy,mo,dd,hh,mm,ss);
            v->year=yy;
            v->month=mo;
            v->day=dd;
            v->hour=hh;
            v->minute=mm;
            v->second=ss;
            sprintf(v->value,"%s", data_value_cnode->getText());
        } else {
            printf("ERROR\n\r");
        }
    } else {
        if (debug_mode)printf("error\n\r");
    }
    return 0;
}



int FIAP::post(struct fiap_element* v, unsigned int esize)
{
    HTTPClient http;
    int i;
    char rstr[1200];
    char requestBuffer[50];
    post_xml_initialize();
    strcpy(_soap_text,_soap_header);
    for (i=0; i<esize; i++) {
        sprintf(requestBuffer,"%04d-%02d-%02dT%02d:%02d:%02d.0000000",v[i].year,v[i].month,v[i].day,v[i].hour,v[i].minute,v[i].second);
        strcat(_soap_text , "<point id=\"");
        strcat(_soap_text , _fiap_id_prefix);
        strcat(_soap_text , v[i].cid);
        strcat( _soap_text, "\">");
        strcat(_soap_text , "<value time=\"");
        strcat(_soap_text , requestBuffer);
        strcat(_soap_text , v[i].timezone);
        strcat(_soap_text , "\">");
        strcat(_soap_text , v[i].value);
        strcat(_soap_text , "</value>");
        strcat(_soap_text , "</point>");
    }
    strcat(_soap_text , _soap_footer);
    if (debug_mode) {
        printf(_soap_text);
        printf("<<< Request(end)\n");
    }
//    http.setRequestHeader("Content-Type","text/xml; charset=UTF-8");
//    http.setRequestHeader("SOAPAction","\"http://soap.fiap.org/data\"");
//    InData=new HTTPText();
    HTTPText InData(_soap_text);
    HTTPText OutData(rstr,1200);
    HTTPResult r = http.postXML(_fiap_storage,"http://soap.fiap.org/data",InData,&OutData);
    if(!r) {
        if (debug_mode)printf("Success \n");
        if (debug_mode) {
            printf("****\n\r");
            printf(rstr);
            printf("\n\r****\n\r");
        }
    } else {
        if (r==HTTP_PROCESSING) {
            if (debug_mode)printf("Processing \n");
            return -1;
        }
        if (r==HTTP_PARSE) {
            if (debug_mode) printf("URI Parse error \n");
            return -1;
        }
        if (r==HTTP_DNS) {
            if (debug_mode) printf("Could not resolve name\n");
            return -1;
        }
        if (r==HTTP_PRTCL) {
            if (debug_mode)printf("Protocol error\n");
            return -1;
        }
        if (r==HTTP_NOTFOUND) {
            if (debug_mode)printf("HTTP 404 Error\n");
            return -1;
        }
        if (r==HTTP_REFUSED) {
            if (debug_mode) printf("HTTP 403 Error \n");
            return -1;
        }
        if (r==HTTP_ERROR) {
            if (debug_mode)printf("HTTP xxx error \n");
            return -1;
        }
        if (r==HTTP_TIMEOUT) {
            if (debug_mode)printf("Connection timeout\n");
            return -1;
        }
        if (r==HTTP_CONN) {
            if (debug_mode)printf("Connection error\n");
            return -1;
        }
        if (r==HTTP_CLOSED) {
            if (debug_mode)printf("Connection error\n");
            return -1;
        }
        if (debug_mode)printf("Unknown Network Error\n");
        return -1;
    }
    return 0;
}