#include "mbed.h"
#include "EthernetNetIf.h"
#include "NTPClient.h"
#include "fiap.h"
#include "TextLCD.h"

#define ntp_server "ntp.cc.yamaguchi-u.ac.jp"

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

EthernetNetIf eth;
NTPClient ntp;
FIAP fiap("http://192.168.1.5/axis2/services/FIAPStorage","http://test.fiap.org/mbed_temp/");

TextLCD lcd(p24, p26, p27, p28, p29, p30);
AnalogIn temp(p20);
Ticker timer;

char timezone[] = "+09:00";  // JST
int ret;
time_t next_record;

struct fiap_element element[]={
    {"TEMP1",NULL,NULL,timezone},
//    {"P2",NULL,NULL,timezone},
};

void send_fiap_storage() {
    //data initialize
    char buffer[17];
    float temp_data=temp.read()*330.0;
    time_t seconds = time(NULL);
    strftime(buffer,17,"  %X  ",localtime(&seconds));
    lcd.locate(0,0);
    lcd.printf("%s",buffer);
    lcd.locate(0,1);
    lcd.printf("TEMP=%4.1f Deg",temp_data);
    if (seconds>=next_record) {
        next_record+=60;
        char data[5];
        sprintf(data,"%4.1f",temp_data);
        element[0].value=data;
        element[0].t=localtime(&seconds);
        //do post
        ret=fiap.post(element,1);
        return ;
    }
}

int main() {
    led1=led2=led3=led4=0;
    lcd.printf("FIAP TEMP");
    fiap.debug_mode=true;
    //EthernetNetIf initialize
    EthernetErr ethErr = eth.setup();
    if (ethErr) {
        //   lcd.locate(0,1);
        //   lcd.printf("Error %d in setup.\n", ethErr);
        return -1;
    }
    led1=1;
    //NTPClient initia,lize
    Host server(IpAddr(), 123, ntp_server);
    NTPResult Ntpr=ntp.setTime(server);
    //UTC-->JST +9Hour(32400Sec)
    time_t ctTime;
    ctTime = time(NULL);
    ctTime+=32400;
    set_time(ctTime);
    led2=1;
    next_record = (time(NULL)/60+1)*60;

    timer.attach(&send_fiap_storage, 1);

    //do
    if (ret!=0) {
        led4=0;
        while (1) {
            led3=!led3;
            wait(0.5);
        }
    } else {
        led3=0;
        while (1) {
            led4=!led4;
            wait(0.5);
        }
    }
}
