#include "mbed.h"
#include "EthernetNetIf.h"
#include "NTPClient.h"
#include "fiap.h"

#define ntp_server "ntp server address"

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

EthernetNetIf eth;
NTPClient ntp;
FIAP fiap("http://192.168.1.5/axis2/services/FIAPStorage","http://test.fiap.org/mbed_hello/");

char timezone[] = "+09:00";  // JST

struct fiap_element element[]={
    {"P1",NULL,NULL,timezone},
    {"P2",NULL,NULL,timezone},
};

int main() {
    led1=led2=led3=led4=0;
    fiap.debug_mode=true;
    //EthernetNetIf initialize
    EthernetErr ethErr = eth.setup();
    if (ethErr) {
        //   lcd.locate(0,1);
        //   lcd.printf("Error %d in setup.\n", ethErr);
        return -1;
    }
    led1=1;
    //NTPClient initia,lize
    Host server(IpAddr(), 123, ntp_server);
    NTPResult Ntpr=ntp.setTime(server);
    //UTC-->JST +9Hour(32400Sec)
    time_t ctTime;
    ctTime = time(NULL);
    ctTime+=32400;
    set_time(ctTime);
    led2=1;

    //post
    int i,j;
    for (j=0; j<10; j++) {
        //data initialize
        time_t seconds = time(NULL);
        for (i=0; i<2; i++) {
        char data[5];
            int s=j*pow((double)10,i);
            sprintf(data,"%03d",s);
            element[i].value=data;
            element[i].t=localtime(&seconds);
        }
        //do post
        int ret=fiap.post(element,2);
        if(ret!=0){
        while (1) {
        led3=!led3;
        wait(0.5);
    }
        return 0;
        }
        wait(1);
    }
    //finish
    while (1) {
        led4=!led4;
        wait(0.5);
    }
}
