#include "fiap.h"
#include "mbed.h"
FIAP::FIAP(string Storage,string PointSetId) {
    debug_mode=false;
    _fiap_storage=Storage;
    _fiap_id_prefix=PointSetId;

    _soap_header ="<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    _soap_header += "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\">";
    _soap_header += "<soapenv:Body>";
    _soap_header += "<ns2:dataRQ xmlns:ns2=\"http://soap.fiap.org/\">";
    _soap_header += "<transport xmlns=\"http://gutp.jp/fiap/2009/11/\">";
    _soap_header += "<body>";
    _soap_header += "<pointSet id=\"" + _fiap_id_prefix +"\">";

    _soap_footer ="</pointSet>";
    _soap_footer+="</body>";
    _soap_footer+="</transport>";
    _soap_footer+="</ns2:dataRQ>";
    _soap_footer+="</soapenv:Body>";
    _soap_footer+="</soapenv:Envelope>";
    _soap_footer+="\r\n\r\n";
}

int FIAP::post(struct fiap_element* v, unsigned int esize) {
    HTTPClient http;
    int i;
    char requestBuffer[50];
    string _date_time;
    string _soap_text=_soap_header;
    for (i=0; i<esize; i++) {
        strftime(&requestBuffer[0],50,"%Y-%m-%dT%H:%M:%S.0000000",v[i].t);
        _soap_text += "<point id=\"";
        _soap_text += _fiap_id_prefix;
        _soap_text += v[i].cid;
        _soap_text += "\">";
        _soap_text += "<value time=\"";
        _soap_text += requestBuffer;
        _soap_text += v[i].timezone;
        _soap_text += "\">";
        _soap_text += v[i].value;
        _soap_text += "</value>";
        _soap_text += "</point>";
    }
    _soap_text += _soap_footer;
if(debug_mode){
printf(_soap_text.c_str());
printf("<<< Request(end)\n");
}
    http.setRequestHeader("Content-Type","text/xml; charset=UTF-8");
    http.setRequestHeader("SOAPAction","\"http://soap.fiap.org/data\"");
    HTTPText InData;
    InData.set(_soap_text.c_str());
    HTTPText OutData;
    HTTPResult r = http.post(_fiap_storage.c_str(),InData,&OutData);
    if (r==HTTP_PROCESSING) {
         if (debug_mode)printf("Processing \n");
        return -1;
    }
    if (r==HTTP_PARSE) {
           if (debug_mode) printf("URI Parse error \n");
        return -1;
    }
    if (r==HTTP_DNS) {
           if (debug_mode) printf("Could not resolve name\n");
        return -1;
    }
    if (r==HTTP_PRTCL) {
           if (debug_mode)printf("Protocol error\n");
        return -1;
    }
    if (r==HTTP_NOTFOUND) {
           if (debug_mode)printf("HTTP 404 Error\n");
        return -1;
    }
    if (r==HTTP_REFUSED) {
           if (debug_mode) printf("HTTP 403 Error \n");
        return -1;
    }
    if (r==HTTP_ERROR) {
           if (debug_mode)printf("HTTP xxx error \n");
        return -1;
    }
    if (r==HTTP_TIMEOUT) {
           if (debug_mode)printf("Connection timeout\n");
        return -1;
    }
    if (r==HTTP_CONN) {
           if (debug_mode)printf("Connection error\n");
        return -1;
    }

    return 0;
}
