//  IEEE1888 / FIAP Uploader Library for Arduino
//
//  2011/09/19 ver.1   H.Inoue & H.Ochiai
//  2011/12/31 Ver.1 for mbed Y.Tauchi

// --------- FIAP.h  ---------
#ifndef MBED_FIAP_H
#define MBED_FIAP_H

#include "mbed.h"
#include "HTTPClient.h"

// return code of post method
#define FIAP_UPLOAD_OK       0  // Succeeded
#define FIAP_UPLOAD_CONNFAIL 1  // Connection faild (Socket I/O error)
#define FIAP_UPLOAD_DNSERR   2  // DNS error
#define FIAP_UPLOAD_HTTPERR  3  // HTTP Server error (The response was not "200 OK")
#define FIAP_UPLOAD_FIAPERR  4  // FIAP Server error

// point element

/** fiap_element 
 *
 *@param cid Point ID
 *@param value Data
 *@param t DateTime
 *@param timezone Timezone ie JST="+09:00"
 */
struct fiap_element {
  const char* cid;       // Set PointID
  string value;           // Set Value
  struct tm *t;           // Set DateTime
  char* timezone;        // Set Timezon JST="+09:00"
};

/** FIAP Class
 *
 *  for mbed
 *
 *Example:
 *@code
 * #include "mbed.h"
 * #include "EthernetNetIf.h"
 * #include "NTPClient.h"
 * #include "fiap.h"
 *  
 * #define ntp_server "ntp server address"
 * 
 * DigitalOut led1(LED1);
 * DigitalOut led2(LED2);
 * DigitalOut led3(LED3);
 * DigitalOut led4(LED4);
 * 
 * EthernetNetIf eth;
 * NTPClient ntp;
 * FIAP ieee1888("http://192.168.1.5/axis2/services/FIAPStorage","http://test.fiap.org/mbed_hello/");
 * 
 * char timezone[] = "+09:00";  // JST
 *
 * struct fiap_element element[]={
 *     {"P1",NULL,NULL,timezone},
 *     {"P2",NULL,NULL,timezone},
 * };
 * 
 * int main() {
 *     led1=led2=led3=led4=0;
 *     ieee1888.debug_mode=true;
 *     //EthernetNetIf initialize
 *     EthernetErr ethErr = eth.setup();
 *     if (ethErr) {
 *         //   lcd.locate(0,1);
 *         //   lcd.printf("Error %d in setup.\n", ethErr);
 *         return -1;
 *     }
 *     led1=1;
 *     //NTPClient initia,lize
 *     Host server(IpAddr(), 123, ntp_server);
 *     NTPResult Ntpr=ntp.setTime(server);
 *     //UTC-->JST +9Hour(32400Sec)
 *     time_t ctTime;
 *     ctTime = time(NULL);
 *     ctTime+=32400;
 *     set_time(ctTime);
 *     led2=1;
 * 
 *     //post
 *     int i,j;
 *     for (j=0; j<10; j++) {
 *         //data initialize
 *         time_t seconds = time(NULL);
 *         for (i=0; i<2; i++) {
 *         char data[5];
 *             int s=j*pow((double)10,i);
 *             sprintf(data,"%03d",s);
 *             element[i].value=data;
 *             element[i].t=localtime(&seconds);
 *         }
 *         //do post
 *         int ret=ieee1888.post(element,2);
 *         if(ret!=0){
 *         while (1) {
 *         led3=!led3;
 *         wait(0.5);
 *     }
 *         return 0;
 *         }
 *         wait(1);
 *     }
 *     //finish
 *     while (1) {
 *         led4=!led4;
 *         wait(0.5);
 *     }
 * }
 *@endcode 
 */
class FIAP {
public: 
/** Create fiap object 
 * @param Storage FIAP Storage Addrees (ie. "http://fiap.org/axis2/services/FIAPStorage")
 * @param PointSetId Point Set ID(ie. http://test.fiap.jp/bldg_1/3F/)
 */
 FIAP(string Storage,string PointSetId);

/** post
 * @param v data vaule
 * @param esize  number of data
 */
  int post(struct fiap_element* v, unsigned int esize);

/** debug_mode
 *  Output XML and Error
 */
bool debug_mode;
  
private: 
  string _fiap_storage;
  string _fiap_id_prefix;
  string _soap_header;
  string _soap_footer;
};

#endif
