/*
Copyright (c) 2010 Peter Barrett

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/
#ifndef OS_TICK 
#define OS_TICK        50000
#endif
#include "USBHost.h"
#include "Utils.h"
#include "TextLCD.h"
#include "EthernetInterface.h"
#include "NTPClient.h"
#include "fiap.h"
#include "mbed.h"

//#define NTPServer "ntp.nict.jp"
#define NTPServer "ntp.cc.yamaguchi-u.ac.jp"

EthernetInterface eth;
NTPClient ntp;
Ticker timer1;
time_t ctTime;
char timezone[] = "+09:00";  // JST
char atemp1[6],atemp2[6],avolt1[6],avolt2[6],afreq1[6],afreq2[6];
char apower_a1[6],apower_a2[6],apower_b1[6],apower_b2[6],apower_c1[6],apower_c2[6],apower_d1[6],apower_d2[6];
char atemp[6],avolt[6],afreq[6], apower1[6],apower2[6],apower3[6],apower4[6];
FIAP fiap("http://192.168.1.3/axis2/services/FIAPStorage");
struct fiap_element element[]= {
    {"http://www.gutp.jp/SmartTap1/temp",atemp1,NULL,NULL,NULL,NULL,NULL,NULL,timezone},
    {"http://www.gutp.jp/SmartTap1/volt",avolt1,NULL,NULL,NULL,NULL,NULL,NULL,timezone},
    {"http://www.gutp.jp/SmartTap1/freq",afreq1,NULL,NULL,NULL,NULL,NULL,NULL,timezone},
    {"http://www.gutp.jp/SmartTap1/watt_1",apower_a1,NULL,NULL,NULL,NULL,NULL,NULL,timezone},
    {"http://www.gutp.jp/SmartTap1/watt_2",apower_b1,NULL,NULL,NULL,NULL,NULL,NULL,timezone},
    {"http://www.gutp.jp/SmartTap1/watt_3",apower_c1,NULL,NULL,NULL,NULL,NULL,NULL,timezone},
    {"http://www.gutp.jp/SmartTap1/watt_4",apower_d1,NULL,NULL,NULL,NULL,NULL,NULL,timezone},
    {"http://www.gutp.jp/SmartTap2/temp",atemp2,NULL,NULL,NULL,NULL,NULL,NULL,timezone},
    {"http://www.gutp.jp/SmartTap2/volt",avolt2,NULL,NULL,NULL,NULL,NULL,NULL,timezone},
    {"http://www.gutp.jp/SmartTap2/freq",afreq2,NULL,NULL,NULL,NULL,NULL,NULL,timezone},
    {"http://www.gutp.jp/SmartTap2/watt_1",apower_a2,NULL,NULL,NULL,NULL,NULL,NULL,timezone},
    {"http://www.gutp.jp/SmartTap2/watt_2",apower_b2,NULL,NULL,NULL,NULL,NULL,NULL,timezone},
    {"http://www.gutp.jp/SmartTap2/watt_3",apower_c2,NULL,NULL,NULL,NULL,NULL,NULL,timezone},
    {"http://www.gutp.jp/SmartTap2/watt_4",apower_d2,NULL,NULL,NULL,NULL,NULL,NULL,timezone},
    {"http://www.gutp.jp/SmartTap1/temp",atemp,NULL,NULL,NULL,NULL,NULL,NULL,timezone},
    {"http://www.gutp.jp/SmartTap1/volt",avolt,NULL,NULL,NULL,NULL,NULL,NULL,timezone},
    {"http://www.gutp.jp/SmartTap1/freq",afreq,NULL,NULL,NULL,NULL,NULL,NULL,timezone},
    {"http://www.gutp.jp/SmartTap1/watt_1",apower1,NULL,NULL,NULL,NULL,NULL,NULL,timezone},
    {"http://www.gutp.jp/SmartTap1/watt_2",apower2,NULL,NULL,NULL,NULL,NULL,NULL,timezone},
    {"http://www.gutp.jp/SmartTap1/watt_3",apower3,NULL,NULL,NULL,NULL,NULL,NULL,timezone},
    {"http://www.gutp.jp/SmartTap1/watt_4",apower4,NULL,NULL,NULL,NULL,NULL,NULL,timezone},
};

/*
    Simple test shell to exercise mouse,keyboard,mass storage and hubs.
    Add 2 15k pulldown resistors between D+/D- and ground, attach a usb socket and have at it.
*/

Serial pc(USBTX, USBRX);
int GetConsoleChar()
{
    if (!pc.readable())
        return -1;
    char c = pc.getc();
    pc.putc(c); // echo
    return c;
}
void InitUSPS();
void USPS_Refresh();
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
Timer t;
Timer t2;
Timer t3;
TextLCD lcd(p24, p26, p27, p28, p29, p30);
extern float WattData1[],WattData2[],WattData3[],WattData4[];
extern int SerialNo[];
extern float TempData[];
extern float VoltData[];
extern float FreqData[];
int main()
{
    int i;
    lcd.cls();
    lcd.printf("Watting....");

    pc.baud(460800);

    eth.init(); //Use DHCP
    eth.connect();
    printf("%s", eth.getIPAddress());
    printf("Trying to update time...\r\n");
    if (ntp.setTime(NTPServer) == 0) {
        printf("Set time successfully\r\n");
        time_t ctTime;
        ctTime = time(NULL);
        ctTime+=32400;
        set_time(ctTime);
        ctTime = time(NULL);
        printf("Time is set to (JST): %s\r\n", ctime(&ctTime));
        printf("finish \n");
    } else {
        lcd.locate(0,1);
        lcd.printf("Error");
        return -1;
    }

    InitUSPS();
    USBInit();
    fiap.debug_mode=1;
    t.start();
    t2.start();
    t3.start();
    while(1) {
        USBLoop();
        if(t>0.1 ) {
            t.start();
            led4=!led4;
            USPS_Refresh();
        }
        if(t2>1) { //Data to LCDText
            t2.start();
            if(SerialNo[0]==0)led1=0;else led1=1;
            if(SerialNo[1]==0)led2=0;else led2=1;
                        lcd.locate(0,0);
            lcd.printf("1:%4.0fW  2:%4.0fW",WattData1[0],WattData2[0]);
            lcd.locate(0,1);
            lcd.printf("3:%4.0fW  4:%4.0fW",WattData3[0],WattData4[0]);
        }
        if(t3>60) { //Data to FiapStorage
            led3=1;
            t3.start();
            char buffer[9];
            ctTime = time(NULL);
            strftime(buffer,9,"%X",localtime(&ctTime));
            printf("Storage Store %s \r\n",buffer);
// Save to FIAPStorage
            struct tm t = *localtime(&ctTime);
            for(i=0; i<14; i++) {
                element[i].year=t.tm_year+1900;
                element[i].month=t.tm_mon+1;
                element[i].day=t.tm_mday;
                element[i].hour=t.tm_hour;
                element[i].minute=t.tm_min;
                element[i].second=t.tm_sec;
            }
              for(i=0; i<2; i++) {
                switch(SerialNo[i]) {
                    case 0x1737:
                        sprintf(atemp1,"%4.1f",TempData[i]);
                        sprintf(avolt1,"%4.1f",VoltData[i]);
                        sprintf(afreq1,"%4.1f",FreqData[i]);
                        sprintf(apower_a1,"%4.0f",WattData1[i]);
                        sprintf(apower_b1,"%4.0f",WattData2[i]);
                        sprintf(apower_c1,"%4.0f",WattData3[i]);
                        sprintf(apower_d1,"%4.0f",WattData4[i]);
                        break;
                    case 0x1871:
                        sprintf(atemp2,"%4.1f",TempData[i]);
                        sprintf(avolt2,"%4.1f",VoltData[i]);
                        sprintf(afreq2,"%4.1f",FreqData[i]);
                        sprintf(apower_a2,"%4.0f",WattData1[i]);
                        sprintf(apower_b2,"%4.0f",WattData2[i]);
                        sprintf(apower_c2,"%4.0f",WattData3[i]);
                        sprintf(apower_d2,"%4.0f",WattData4[i]);
                        break;
                }
            }
            fiap.post(element,14);
            led3=0;
            
        }
    }
}
