#include "mbed.h"
#include "USBHost.h"
#include "Utils.h"

u8 ms_buf[0x1A];  // USPS Streaming Buffer
int nUSPS;
int dUSPS[10];
int eUSPS[10];
int SerialNo[10];
float TempData[10];
float VoltData[10];
float FreqData[10];
float WattData1[10],WattData2[10],WattData3[10],WattData4[10];
void usps_cmd(int device,int cmd,int val,int len,int evt);
void usps_measurement_mode(int device);
void USPS_Refresh();

bool usps_debug=true;

/* protocol */
#define USPS_CMD_START        0x01
#define USPS_CMD_VALUE        0x20
#define USPS_CMD_GET_FIRMWARE    0xc0
#define USPS_CMD_GET_SERIAL    0xc1
#define USPS_CMD_GET_VOLTAGE    0xb0
#define USPS_CMD_GET_TEMP    0xb4
#define USPS_CMD_GET_FREQ    0xa1

#define USPS_MODE_WATTAGE    0x10
#define USPS_MODE_CURRENT    0x30

#define EVENT_GET_FIRMWARE 0x11
#define EVENT_GET_SERIAL   0x12
#define EVENT_GET_TEMP   0x21
#define EVENT_GET_VOLT   0x22
#define EVENT_GET_FREQ   0x23
#define EVENT_GET_POWER   0x24
#define EVENT_START   0x13
#define EVENT_VALUE   0x14

float temp;
float volt;
float freq;
float power1,power2,power3,power4;
unsigned char cmdFlag;
bool initFlag;
void InitUSPS()
{
    int i;
    nUSPS=0;
    for(i=0; i<10; i++)SerialNo[i]=0;
    initFlag=false;
}

void UspsEventCallback(int device, int endpoint, int status, u8* data, int len, void* userData)
{
    int i,i1,i2,sn;
    int Flag=0;
    if(status!=0) {
        i1=0;
        if(usps_debug)     printf("USPS Callback Status %d \n\r",status);
        for(i=0; i<nUSPS; i++) {
            if(dUSPS[i]==device) {
                i1=i;
                Flag=1;
            }
        }
        if(Flag==1) {
            for(i=i1+1; i<nUSPS; i++) {
                dUSPS[i-1]=dUSPS[i];
                eUSPS[i-1]=eUSPS[i];
                SerialNo[i-1]=SerialNo[i];
                TempData[i-1]=TempData[i];
                VoltData[i-1]=VoltData[i];
                FreqData[i-1]=FreqData[i];
                WattData1[i-1]=WattData1[i];
                WattData2[i-1]=WattData2[i];
                WattData3[i-1]=WattData3[i];
                WattData4[i-1]=WattData4[i];
            }
            nUSPS--;
        }
        return;
    }
    i2=(int)userData;
    switch(i2) {
        case EVENT_GET_FIRMWARE:
            if(usps_debug) printf("USPS Device#%X Firmware VOL%X REL%X\r\n",device,data[0],data[1]);
            break;

        case EVENT_GET_SERIAL:
            i1=0;
            sn=data[0]<<16|data[1]<<8|data[2];
            if(usps_debug) printf("USPS Device#%x SerialNo %X \r\n",device,sn);
            for(i=0; i<nUSPS; i++) {
                if(SerialNo[i]==sn) {
                    i1=i;
                    Flag=1;
                }
            }
            if(Flag==1) {
                for(i=i1+1; i<nUSPS; i++) {
                    dUSPS[i-1]=dUSPS[i];
                    eUSPS[i-1]=eUSPS[i];
                    SerialNo[i-1]=SerialNo[i];
                    TempData[i-1]=TempData[i];
                    VoltData[i-1]=VoltData[i];
                    FreqData[i-1]=FreqData[i];
                    WattData1[i-1]=WattData1[i];
                    WattData2[i-1]=WattData2[i];
                    WattData3[i-1]=WattData3[i];
                    WattData4[i-1]=WattData4[i];
                }
                nUSPS--;
            }
            for(i=0; i<nUSPS; i++) {
                if(dUSPS[i]==device)SerialNo[i]=sn;
            }
            for(i=0; i<nUSPS; i++) {
                if(usps_debug)     printf( "Serial(%d) : %X \n\r",i,SerialNo[i]);
            }
            break;

        case EVENT_GET_TEMP:
            i=data[1]<<8|data[0];
            temp=i/100.0;
            if(usps_debug)  printf("USPS Device#%x Temp %5.2f \r\n",device,temp);
            for(i=0; i<nUSPS; i++) {
                if(dUSPS[i]==device)TempData[i]=temp;
            }
            break;

        case EVENT_GET_VOLT:
            volt=data[0];
            if(usps_debug)   printf("USPS Device#%x Volt %6.2f \r\n",device,volt);
            for(i=0; i<nUSPS; i++) {
                if(dUSPS[i]==device)VoltData[i]=volt;
            }
            break;

        case EVENT_GET_FREQ:
            i=data[1]<<8|data[0];
            freq=2000000.0/i;
            if(usps_debug)  printf("USPS Device#%x Freq %5.2f \r\n",device,freq);
            for(i=0; i<nUSPS; i++) {
                if(dUSPS[i]==device)FreqData[i]=freq;
            }
            break;

        case EVENT_GET_POWER:
            power4=(unsigned short)(data[0xf]<<8|data[0xe]);
            power3=(unsigned short)(data[0xd]<<8|data[0xc]);
            power2=(unsigned short)(data[0xb]<<8|data[0xa]);
            power1=(unsigned short)(data[0x9]<<8|data[0x8]);
            if(usps_debug)  printf("USPS Device#%x:Power1 %5.0f[W]:Power2 %5.0f[W]:Power3 %5.0f[W]:Power4 %5.0f[W]\r\n",device,power1,power2,power3,power4);
            for(i=0; i<nUSPS; i++) {
                if(dUSPS[i]==device) {
                    WattData1[i]=power1;
                    WattData2[i]=power2;
                    WattData3[i]=power3;
                    WattData4[i]=power4;
                }
            }
            break;

        default:
            if(usps_debug)   printf("usps response \r\n");
            if(usps_debug)  printf("USPS %02X %02X %02X \r\n",device,status,len);
            if(usps_debug)  printfBytes("",data,len);
            break;
    }
}

//  Add Usps Interface
void USPS_Refresh()
{
    static int i=0;
    static int k=0;
    u8* dst = ms_buf;
    //for (i=0; i<nUSPS; i++) {
    if(nUSPS==0)return;
    if(initFlag==true) {
        for(i=0; i<nUSPS; i++) {
            if(SerialNo[i]==0) {
                usps_cmd(dUSPS[i],USPS_CMD_GET_SERIAL  ,0,3,EVENT_GET_SERIAL);
                usps_measurement_mode(dUSPS[i]);
            }
        }
        k=0;
        for(i=0; i<nUSPS; i++)if(SerialNo[i]==0)k=1;
        if(k==0)initFlag=false;
    } else {
        if(i==nUSPS)i=0;
        switch(k) {
            case 0:
                usps_cmd(dUSPS[i],USPS_CMD_GET_TEMP ,0,2,EVENT_GET_TEMP);
                k++;
                break;
            case 1:
                usps_cmd(dUSPS[i],USPS_CMD_GET_VOLTAGE, 0, 1,EVENT_GET_VOLT);
                k++;
                break;
            case 2:
                usps_cmd(dUSPS[i],USPS_CMD_GET_FREQ, 0, 8,EVENT_GET_FREQ);
                k++;
                break;
            case 3:
                USBInterruptTransfer(dUSPS[i], eUSPS[i], dst,0x10, UspsEventCallback, (void*)EVENT_GET_POWER);
                k=0;
                i++;
                break;
        }
    }
    //}
}

void AddUspsInterface(int device, InterfaceDescriptor* id, EndpointDescriptor* ed,int len)
{
    if ((ed->bmAttributes & 3) != ENDPOINT_INTERRUPT || !(ed->bEndpointAddress & 0x80))
        return;
    dUSPS[nUSPS]=device;
    eUSPS[nUSPS]=ed->bEndpointAddress;
    SerialNo[nUSPS]=0;
    nUSPS++;
    if(usps_debug)  printf("No of USPS :%d\n\r",nUSPS);
    initFlag=true;
//    usps_cmd(device,USPS_CMD_GET_FIRMWARE ,0,2,EVENT_GET_FIRMWARE);
//    usps_cmd(device,USPS_CMD_GET_SERIAL  ,0,3,EVENT_GET_SERIAL);
//    usps_measurement_mode(device);
}

void usps_measurement_mode(int device)
{
    u8* dst = ms_buf;
    USBControlTransfer(device, 0x40, USPS_CMD_START ,0, 0, dst, 0,UspsEventCallback,(void*)EVENT_START); //UT_Vendor_Write
    USBControlTransfer(device, 0x40, USPS_CMD_VALUE ,USPS_MODE_WATTAGE , 0, dst, 0,UspsEventCallback,(void*)EVENT_VALUE); //UT_Vendor_Write
}

void usps_cmd(int device,int cmd,int val,int len,int evt)
{
    int i;
    u8* dst = ms_buf;
    // printf("req\n\r");
    i= USBControlTransfer(device, 0xc0,  cmd,val, 0, dst, len,UspsEventCallback,(void*)evt);
    if(i!=-100) printf("status : %d \r\n",i);
}
//  Detected USPS Device
int OnUspsInsert(int device)
{
    u8 buffer[255];
    int err = GetDescriptor(device,DESCRIPTOR_TYPE_CONFIGURATION,0,buffer,255);
    if (err < 0)
        return err;
    int len = buffer[2] | (buffer[3] << 8);
    u8* d = buffer;
    u8* end = d + len;

    if(usps_debug) printf("OnUspsInsert %02X %02X\r\n",device,len); //
    //printfBytes("  -->",d,len);
    while (d < end) {
        if (d[1] == DESCRIPTOR_TYPE_INTERFACE) {
            InterfaceDescriptor* id = (InterfaceDescriptor*)d;
            d += d[0];
            while (d < end) {
                if (d[1] == DESCRIPTOR_TYPE_ENDPOINT) {
                    if(usps_debug)  printfBytes("Usps Endpoint",d,d[0]);
                    AddUspsInterface(device,id,(EndpointDescriptor*)d,d[4]);
                }
                d += d[0];
            }
        }
        d += d[0];
    }
    return 0;
}
