#include "mbed.h"
#include "ChainableLED.h"

#define NUM_LED 1

DigitalOut myled(LED1);
DigitalIn TouchPin(D8);
ChainableLED led(D6,D7,NUM_LED);
InterruptIn motion(D2);

int motion_detected = 0;

void irq_handler(void)
{
    motion_detected = 1;
}

int main() {
    uint8_t index = 0;
    int cnt = 0;
    motion.rise(&irq_handler);
    while(1) {
         
//        myled = 1; // LED is ON
//        wait(0.2); // 200 ms
//        myled = 0; // LED is OFF
//        wait(1.0); // 1 sec
          int touch_value=TouchPin.read();
          
          //if(touch_value==1){
          if(motion_detected){
          //led.setColorHSB(0,hue,1.0,0.5);
          cnt++;
          motion_detected=0;
          printf("Hello! I've detected %d times since reset\n", cnt);
          printf("\r\n");
          // generate random RGB values for LED's
          uint8_t R = rand();
          uint8_t G = rand();
          uint8_t B = rand();
          
          // print message to terminal
          printf("index = %d, R=%x,G=%x,B=%x,",index,R,G,B);
          printf("\r\n");
          // ChainableLED.setColorRGB(index_of_led, red, green, blue)
          led.setColorRGB(index++, R, G, B);    // increase brightness cascade down chain of LED's
          index = ((index+1) % NUM_LED);              // cycle through LED's
          //wait(1);
          }
    }
}
