#include "mbed.h"
#include <math.h>

#define b 3380.0f  // 热敏电阻的b值
#define r25c 10.0f // 25摄氏度时热敏电阻的阻值,单位千欧
#define rRef 10.062f // 电路中分压电阻的阻值,单位千欧

AnalogIn analog_value(A0);

Serial pc(USBTX,USBRX);

int main()
{
    int count=0;
    float sum=0;
    pc.baud(115200);
    while(1) {
        
        uint16_t rawAdc = analog_value.read_u16()>>4; // 保留12bit
        //printf("Raw ADC value:%d\r\n",rawAdc);
        float rth=rRef*(4096.0f/rawAdc-1.0f);
        //printf("Thermistor value:%f kOhm\r\n",rth);
        float t;
        
        t=(298.0f*b)/logf(r25c/rth)/(b/logf(r25c/rth)-298.0f)-273.0;

        if(count<10) {
            count++;
            sum+=t;
        } else {
            printf("Temperature:%.1f C\r\n",sum/10.0f);
            count=0;
            sum=0;
        }

        wait(0.1); // 100 ms
    }
}
