#include "mbed.h"
#include <string.h>
#include "hanabi.h"

#define BAR0 0x01
#define BAR1 0x2
#define BAR2 0x4
#define BAR3 0x8
#define BAR4 0x10
#define BAR5 0x1
#define BAR6 0x2
#define BAR7 0x4
#define BAR8 0x8
#define BAR9 0x10

const char bar[10] = {BAR0, BAR1, BAR2, BAR3, BAR4, BAR5, BAR6, BAR7, BAR8, BAR9};

#define TIME 25     //us


DigitalOut red(D1);
DigitalOut blue(D0);
DigitalOut green(D2);

DigitalOut bar0(D12);
DigitalOut bar1(D11);
DigitalOut bar2(D10);
DigitalOut bar3(D9);
DigitalOut bar4(D8);
DigitalOut bar5(D7);
DigitalOut bar6(D6);
DigitalOut bar7(A0);
DigitalOut bar8(A1);
DigitalOut bar9(A2);

Serial pc(USBTX, USBRX);
Ticker timer;

char RGB(char , char, char);
void TMred0_ISR();
void swap_ary(char (*after)[2], char const before[180][2]){
            memcpy(after, before, 360);
            pc.printf("test\n");
        
    
}
void print_ary(char (*after)[2]){
    for(int i = 0; i < 180; i++){
        for(int j = 0; j < 2;j++){
            pc.printf("%d\n", after[i][j]);
        }
    }
}
int main(){
    bool tim_flag = 0;
    char tim = 250;
    char chr;
    timer.attach(&TMred0_ISR, 0.1);
    pc.baud(115200);
    while(1){
        //pc.printf("ordered0");
        
        if(chr == 'w'){
            tim ++;
            tim_flag = 1;
        }else if(chr == 's'){
            tim --;
            tim_flag = 1;
        }
        
        if(tim_flag){
            pc.printf("period: %d, freq: %f\n", tim, float(1/tim));
            timer.detach();
            timer.attach_us(&TMred0_ISR, tim);
            tim_flag = 0;
        }
    }
}

void TMred0_ISR(void)
{
    static char i = 0;
    static short j = 0;
    static char time = 0;
    static char phase = 0;
    static char red_v[180][2] = {0};
    static char green_v[180][2] = {0};
    static char blue_v[180][2] = {0};
    static char col = 0;
    char judge_red = 0, judge_green = 0, judge_blue = 0;

    pc.printf("%d\n", time);
    if(time == 50){
        phase ++;
        time = 0;
        switch(phase){
            case 1:
                swap_ary(red_v, full);
                swap_ary(green_v, emp);
                swap_ary(blue_v, emp);
                    print_ary(red_v);
                break;
            case 2:
                swap_ary(red_v, emp);
                swap_ary(green_v, full);
                swap_ary(blue_v, emp);
                break;
            case 3:
                swap_ary(red_v, emp);
                swap_ary(green_v, emp);
                swap_ary(blue_v, full);
                break;
            case 4:
                swap_ary(red_v, emp);
                swap_ary(green_v, emp);
                swap_ary(blue_v, emp);
                phase = 0;
                break;
        }
    }
    //pc.printf("%d\n", i);

    judge_red = red_v[j][col] & bar[i];
    judge_green = green_v[j][col] & bar[i];
    judge_blue = blue_v[j][col] & bar[i];
    
    switch(i){
        case 0:
            bar9 = 0;
            bar0 = RGB(judge_red, judge_green, judge_blue);
            break;
        case 1:
            bar0 = 0;
            bar1 = RGB( judge_red, judge_green, judge_blue);            
            break;
        case 2:
            bar1 = 0;
            bar2 = RGB(judge_red, judge_green, judge_blue);
            break;
        case 3:
            bar2 = 0;
            bar3 = RGB(judge_red, judge_green, judge_blue);
            break;
        case 4:
            bar3 = 0;
            bar4 = RGB(judge_red, judge_green, judge_blue);
            col = 1;
            break;
        case 5:
            bar4 = 0;
            bar5 = RGB(judge_red, judge_green, judge_blue);
            break;
        case 6:
            bar5 = 0;
            bar6 = RGB(judge_red, judge_green, judge_blue);
            break;
        case 7:
            bar6 = 0;
            bar7 = RGB(judge_red, judge_green, judge_blue);
            break;
        case 8:
            bar7 = 0;
            bar8 = RGB(judge_red, judge_green, judge_blue);
            break;
        case 9:
            bar8 = 0;
            bar9 = RGB(judge_red, judge_green, judge_blue);
            col = 0;
            break; 
    }
    
    i++;
    j++;
    time++;
    if(i > 9)
        i = 0;
    if(j > 180)
        j = 0;


}

char RGB(char judge_red, char judge_green, char judge_blue){    
    char flag = 1;
    
    if(judge_red && judge_green && judge_blue){
        red=0;
        green=0;
        blue=0;
        //pc.printf(", order1");
    }else if(judge_red && judge_green){
        red=0;
        green=0;
        blue=1;
        
    }else if(judge_red && judge_blue){
        red=0;
        green=1;
        blue=0;
    }else if(judge_blue && judge_green){
        red=1;
        green=0;
        blue=0;
    }else if(judge_red){
        red=0;
        green=1;
        blue=1;
    }else if(judge_green){
        red=1;
        green=0;
        blue=1;
    }else if(judge_blue){
        red=1;
        green=1;
        blue=0;
    }else{
        red=1;
        green=1;
        blue=1;
        flag = 0;
    }
    return flag;
}

