/*
 * Test 2 iz PIM
 *
 */
 
/*
 * Biblioteke za uvoz:
 */
#include "mbed.h"
 
/*
 * Definisanje makroa:
 */
#define A PA_10
#define B PA_9
#define C PA_8
#define D PB_10
#define E PB_5
#define F PB_4
#define G PB_3
#define SEL1 PB_6
#define SEL2 PC_7
#define SW1 PC_9
#define SW2 PC8

/*
 * Globalne promenljive:
 */
BusOut display (A,B,C,D,E,F,G);
BusOut select (SEL2,SEL1);
AnalogIn pot2(PA_1);
AnalogIn pot1(PA_0);
PwmOut buzz(PA_11);
InterruptIn button_sw1 (SW1);

int broj;
float frekvencija; 
bool ispis = false;

/*
 * Deklaracija funkcija:
 */
 void SegDisp (int broj);
 void ispisi(int num);
 void ISR_button_sw1();

/*
 * Glavna funkcija:
 */
int main()
{
    
    
    // Glavna petlja:
    while(true)
    {
        button_sw1.fall(&ISR_button_sw1);
        buzz.write(pot1.read()*0.1);
        frekvencija = 200+(pot2.read()*19800);
        buzz.period(1.0/frekvencija);
        wait_ms(1);
        
        if(ispis == true)
        {
            ispisi(broj);
        }
        
    }    
}


/*
 * Definicija funkcija:
 */

 // ispis cifara na displej
void SegDisp (int broj)
{
    switch(broj)
    {
        case 0: display = 0b1000000; break;
        case 1: display = 0b1111001; break;
        case 2: display = 0b0100100; break;
        case 3: display = 0b0110000; break;
        case 4: display = 0b0011001; break;
        case 5: display = 0b0010010; break;
        case 6: display = 0b0000010; break;
        case 7: display = 0b1111000; break;
        case 8: display = 0b0000000; break;
        case 9: display = 0b0010000; break;
        default: display = 0x7f;     break;
    }
}


//konvertovanje broj u cifre i ispis
void ispisi(int num)
{
    int j = num%10,d = num/10;
    if(d==0)
        SegDisp(-1);
    else
        SegDisp(d);
         
    select = 0b01;
    wait_ms(2);
    SegDisp(j);
    select = 0b10;
    wait_ms(1);
    
}

//prekidna rutina za SW1
void ISR_button_sw1()
{
    ispis = true;
    broj = int(pot1.read()*100);
}



