#include "mbed.h"

DigitalOut led(D3);   // LED 的腳位
DigitalIn sw(D2);     // 開關的腳位
bool lastState = 0; 
// 記錄上次的開關狀態，預設為「低電位」
bool toggle = 0;    
// 輸出給 LED 的訊號，預設為「低電位」
int click = 0;      
  // 開關訊號的改變次數，預設為 0
int main() {
lastState = sw.read();  
 // 讀取開關的初始值

while(1) 
{
   bool b1 = sw.read();
   if (b1 != lastState)  {     // 如果和之前的開關值不同...
      wait_ms(20);               // 等待 20 毫秒
      bool b2 = sw.read();   // 再讀取一次開關值
      if (b1 == b2) {    // 確認兩次開關值是否一致
      lastState = b1;  // 儲存開關的狀態
      click ++;        // 增加訊號變化次數
    }
  }

  if (click == 2) {    // 如果開關狀態改變兩次
    click = 0;         // 狀態次數歸零
    toggle = !toggle;        // 取相反值
    led = !led;;   // 輸出
  }
}
}

