#include "mbed.h"
#include "EthernetInterface.h"
#include "TCPSocketConnection.h"

EthernetInterface eth;
RawSerial pc(USBTX, USBRX); // tx, rx

int main()
{
    pc.baud(9600);
    eth.init(); //Use DHCP
    eth.connect();
    printf("IP Address is %s \n\r", eth.getIPAddress());
    TCPSocketConnection socket;
    
    socket.connect("httpbin.org", 80);
    
    char http_cmd[] = "GET /get?helloworld HTTP/1.0\r\n\r\n";
    socket.send_all(http_cmd, sizeof(http_cmd)-1);
    
    char buffer[300];
    int ret;
    while (true) {
        ret = socket.receive(buffer, sizeof(buffer)-1);
        if (ret <= 0)
            break;
        buffer[ret] = '\0';
        printf("Received %d chars from server:\n%s\n", ret, buffer);
    }
      
    printf("DONE!\n");
      
    socket.close();
    
    eth.disconnect();
    
    while(1) {}
}
extern "C" void mbed_mac_address(char *mac)
{
    mac[0] = 0xD4;
    mac[1] = 0x3D;
    mac[2] = 0x7E;
    mac[3] = 0x3C;
    mac[4] = 0x7E;
    mac[5] = 0x1C;
};