#include "mbed.h"
#include "SDFileSystem.h"

Serial pc(USBTX, USBRX);
SDFileSystem sd(PC_3, PC_2, PB_10, PE_2, "sd"); // MOSI, MISO, SCK, CS

FILE *fp;

int main() {
    
    wait(2);
    pc.printf("Initializing\r\n");
    
    fp = fopen("/sd/hello.txt", "r");
    if (fp != NULL) {
        fclose(fp);
        remove("/sd/hello.txt");
        pc.printf("Remove an existing file with the same name\r\n");
    }
    
    fp = fopen("/sd/hello.txt", "w");
    if (fp == NULL) {
        pc.printf("Unable to write the file\r\n");
    } else {
        fprintf(fp, "mbed SDCard application!");
        fclose(fp);
        pc.printf("File successfully written!\r\n");
    }
}
