#include "mbed.h"

// PC_3: DIN, PB_10: CLK, D2: LOAD/CS
SPI max72_spi(PC_3, NC, PB_10);
DigitalOut load(D2);

int maxInUse = 1;    //change this variable to set how many MAX7219's you'll use

// define max7219 registers
#define max7219_reg_noop         0x00
#define max7219_reg_digit0       0x01
#define max7219_reg_digit1       0x02
#define max7219_reg_digit2       0x03
#define max7219_reg_digit3       0x04
#define max7219_reg_digit4       0x05
#define max7219_reg_digit5       0x06
#define max7219_reg_digit6       0x07
#define max7219_reg_digit7       0x08
#define max7219_reg_decodeMode   0x09
#define max7219_reg_intensity    0x0a
#define max7219_reg_scanLimit    0x0b
#define max7219_reg_shutdown     0x0c
#define max7219_reg_displayTest  0x0f

#define LOW 0
#define HIGH 1
#define MHZ 1000000

void maxSingle( int reg, int col) {
//maxSingle is the "easy"  function to use for a
//single max7219
    load = LOW;            // begin
    max72_spi.write(reg);  // specify register
    max72_spi.write(col);  // put data
    load = HIGH;           // make sure data is loaded (on rising edge of LOAD/CS)
}

void maxAll (int reg, int col) {    // initialize  all  MAX7219's in the system
    load = LOW;                    // begin
    for ( int c=1; c<= maxInUse; c++) {
        max72_spi.write(reg);  // specify register
        max72_spi.write(col);  // put data
    }
    load = HIGH;
}

void maxOne(int maxNr, int reg, int col) {
//maxOne is for adressing different MAX7219's,
//while having a couple of them cascaded
    int c = 0;
    load = LOW;

    for ( c = maxInUse; c > maxNr; c--) {
        max72_spi.write(0);  // no-op
        max72_spi.write(0);  // no-op
    }

    max72_spi.write(reg);  // specify register
    max72_spi.write(col);  // put data

    for ( c=maxNr-1; c >= 1; c--) {
        max72_spi.write(0);  // no-op
        max72_spi.write(0);  // no-op
    }
    load = HIGH;
}


void setup () {
    // initiation of the max 7219
    // SPI setup: 8 bits, mode 0
    max72_spi.format(8, 0);
    
    // going by the datasheet, min clk is 100ns so theoretically 10MHz should work...
    // max72_spi.frequency(10*MHZ);
    
    maxAll(max7219_reg_scanLimit, 0x07);
    maxAll(max7219_reg_decodeMode, 0x00);  // using an led matrix (not digits)
    maxAll(max7219_reg_shutdown, 0x01);    // not in shutdown mode
    maxAll(max7219_reg_displayTest, 0x00); // no display test
    for (int e=1; e<=8; e++) {    // empty registers, turn all LEDs off
        maxAll(e,0);
    }
    maxAll(max7219_reg_intensity, 0x0f & 0x0f);    // the first 0x0f is the value you can set
    // range: 0x00 to 0x0f
}


/*   maxSingle(1,1);                       //  - - - - - - - +      
     maxSingle(2,2);                       //  - - - - - - + -
     maxSingle(3,4);                       //  - - - - - + - -
     maxSingle(4,8);                       //  - - - - + - - -
     maxSingle(5,16);                      //  - - - + - - - -
     maxSingle(6,32);                      //  - - + - - - - -
     maxSingle(7,64);                      //  - + - - - - - -
     maxSingle(8,128);                     //  + - - - - - - -
     wait_ms(2000);
     */
int main() {
    setup ();
    while(1){
            for(int i=1;i<=8;i++){
            for(int j=1;j<=128;j*=2){
            maxSingle(i,j);
            wait(0.1);
            }
            }
            for(int i=8;i>=1;i--){
            for(int j=128;j>=1;j*=0.5){
            maxSingle(i,j);
            wait(0.1);
            }
            }
    }
}