#include "MicroBit.h"
#include "DigitDisplay.h"
#include "RangeFinder.h"

MicroBitDisplay display;
//DigitDisplay digit(P0_3, P0_22); // P0/P14
DigitDisplay digit(P0_2, P0_21); // P1/P15

RangeFinder rf(P0_3, 10, 5800.0, 100000);

int main()
{
    float d;

    while(1) {
        d = rf.read_m() * 100;
        digit.write(0,(int)d / 1000 % 10);
        digit.write(1,(int)d / 100 % 10);
        digit.write(2,(int)d / 10 % 10);
        digit.write(3,(int)d / 1 % 10);
        wait(1);
    }
}