#include "mbed.h"
#include "EthernetInterface.h"

#if defined(TARGET_LPC1114)
    SPI spi(dp2, dp1, dp6); // mosi, miso, sclk
    EthernetInterface eth(&spi, dp25, dp26); // spi, cs, reset
    AnalogIn pot1(dp13);
#else
    EthernetInterface eth;
    AnalogIn pot1(p19);
    AnalogIn pot2(p20);
#endif 

#if defined(TARGET_LPC1768)
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4); 
#endif

TCPSocketConnection sock;
 
int main() 
{
// YOU NEED TO TYPE THESE TWO VALUES
    char *EVENT = "PUT YOUR EVENT NAME HERE";
    char *KEY = "PUT YOUT SECRET KEY HERE";
//
    
    char* ip;
    
    int http_cmd_sz=800;
    char http_cmd[http_cmd_sz];
    int buffer_sz=300;  
    char buffer[buffer_sz];  
    int returnCode = 0;
    
#if defined(TARGET_LPC1768)    
    led1 = 1;
    led2 = 1;
    led3 = 1;
    led4 = 1;
#endif
    
    printf("initializing Ethernet\r\n");
    returnCode = eth.init(); //Use DHCP
 
    if ( returnCode == 0 )
    {
        printf(" - Ethernet ready\r\n");
#if defined(TARGET_LPC1768)    
        led1 = returnCode;
#endif        
    }
    else
    {
        printf(" - Could not initialize Ethernet - ending\r\n");
        return 0;
    }
    
    printf("Ethernet.connecting \r\n");
    returnCode = eth.connect();
    printf(" - connecting returned %d \r\n", returnCode);
#if defined(TARGET_LPC1768)    
    led2 = returnCode != -1 ? 0: 1;
#endif    
    printf("Trying to get IP address..\r\n");
    ip = eth.getIPAddress();
#if defined(TARGET_LPC1768)        
    led3 = strlen(ip)<4 ? 1: 0;
#endif    
    printf("  -  IP address:%s\r\n", ip);
    
            sock.connect("maker.ifttt.com", 80);
            snprintf(http_cmd, http_cmd_sz,  "GET /trigger/%s/with/key/%s HTTP/1.1\r\nHost: maker.ifttt.com\r\n\r\n", EVENT, KEY);
            sock.send_all(http_cmd, http_cmd_sz-1);
    
            while ( (returnCode = sock.receive(buffer, buffer_sz-1)) > 0)
            {
                buffer[returnCode] = '\0';
                printf("Received %d chars from server:\n\r%s\n", returnCode, buffer);
            }
            sock.close();
}
