#include "mbed.h"
#include "EthernetInterface.h"
#include "TCPSocketConnection.h"
#include "ifttt.h"

EthernetInterface eth;
Serial pc(USBTX, USBRX); // tx, rx

int main()
{
    pc.baud(9600);
    eth.init(); //Use DHCP
    eth.connect();
    TCPSocketConnection socket;

    // Initialize ifttt object, add up to 3 optional values, trigger event.
    IFTTT ifttt("EventName","SecurityKey", &socket); // EventName, Secret Key, socket to use

    // Send Data using POST
    ifttt.addIngredients("hogehoge"); //Value1
    ifttt.trigger(IFTTT_POST);
}
