#include "mbed.h"
// import Library from http://mbed.org/projects/cookbook/svn/EMAC/lwip/trunk
// Name: HTTPClient
#include "HTTPClient.h"

DigitalOut led(LED1);

// see http://mbed.org/projects/cookbook/api/EMAC/lwip/trunk/HTTPClient/HTTPClient#HTTPClient.HTTPClientd
HTTPClient http("wolf",                 // Brings up the device with static IP address and domain name.
                IPv4(192,168,15,123),   // IPv4 address
                IPv4(255,255,255,0),    // netmask
                IPv4(192,168,15,2),     // default gateway
                IPv4(192,168,15,2));    // dns server
                
LocalFileSystem local("local");
/**
 * Request a google search for HelloWorld and display the first 2000 characters 
 * of the page source on the serial terminal.
 */
int main(void) {
  char url[256];

  // Open a file to write.
  FILE *fd = fopen("/local/hello.htm", "w");

  // Insert the search term into the URL
  sprintf(url, "http://www.google.co.jp/search?hl=en&q=%s&btnG=Search&meta=", "HelloWorld");

  // Request a page and store it into a file.
  http.get(url, fd);

  // Close the file.
  fclose(fd);

  // The file is written on the local disk.
  // "/hello.htm" Have a look.

  // Work is done!
  while(1) {
    led = !led;
    wait(0.2);
  }
}
