#include "mbed.h"

Serial pc(USBTX, USBRX); // tx, rx
SPI spi(p11, p12, p13); // mosi, miso, sclk
DigitalOut cs(p10);

unsigned char matrixdata32[32]; //16×16用表示データ
unsigned char matrixdata16[16]; //16×8用表示データ

/*漢字ROMとやりとり*/
//readFontJIS(JIS上位8bit,JIS下位8bit);
void readFontJIS(uint8_t c1, uint8_t c2)
{
    /*jisx変換後の表示*/
    pc.printf("JIS X up8 = 0x%x downn8 = 0x%x\r\n", c1, c2);

    /*jisxの区点を求める*/
    uint32_t MSB = c1 - 0x20;//区
    uint32_t LSB = c2 - 0x20;//点
    /*JISの句点番号で分類*/
    uint32_t Address = 0;

    pc.printf("MSB = d%d LSB = d%d\r\n", MSB, LSB);
    /*各種記号・英数字・かな(一部機種依存につき注意,㍍などWindowsと互換性なし)*/
    if (MSB >= 1 && MSB <= 15 && LSB >= 1 && LSB <= 94)
        Address = ( (MSB - 1) * 94 + (LSB - 1)) * 32;
    /*第一水準*/
    if (MSB >= 16 && MSB <= 47 && LSB >= 1 && LSB <= 94)
        Address = ( (MSB - 16) * 94 + (LSB - 1)) * 32 + 43584;
    /*第二水準*/
    if (MSB >= 48 && MSB <= 84 && LSB >= 1 && LSB <= 94)
        Address = ((MSB - 48) * 94 + (LSB - 1)) * 32 + 138464;

    /*GT20L16J1Y内部では1区と同等の内容が収録されている*/
    if (MSB == 85 && LSB >= 0x01 && LSB <= 94)
        Address = ((MSB - 85) * 94 + (LSB - 1)) * 32 + 246944;

    /*GT20L16J1Y内部では2区、3区と同等の内容が収録されている*/
    if (MSB >= 88 && MSB <= 89 && LSB >= 1 && LSB <= 94)
        Address = ((MSB - 88) * 94 + (LSB - 1)) * 32 + 249952;

    /*漢字ROMにデータを送信*/
    // Deselect the device
    cs = 1;
    pc.printf("Address = %u \r\n", Address);

    // Setup the spi for 8 bit data, high steady state clock
    spi.format(8,3);
    spi.frequency(1000000);

    // Select the device by seting chip select low
    cs = 0;
    spi.write(0x03);    // Read data byte
    spi.write(Address >> 16  & 0xff);
    spi.write(Address >> 8   & 0xff);
    spi.write(Address        & 0xff);

    /*漢字ROMからデータを受信*/
    for (int i = 0; i < 32; i++) {
        matrixdata32[i] = spi.write(0x00);
    }
    // Deselect the device
    cs = 1;
}//spireadfont


/*漢字ROMとやりとり*/
//readFontASCII(ASCIIコード);
void readFontASCII(uint8_t ASCIICODE)
{
    pc.printf("ASCII,0x");
    pc.printf("%x\r\n", ASCIICODE); //10/07
    uint32_t Address = 0;
    /*ASCII文字*/
    if (ASCIICODE >= 0x20 && ASCIICODE <= 0x7F)
        Address = ( ASCIICODE - 0x20) * 16 + 255968;

    /*漢字ROMにデータを送信*/
    // Deselect the device
    cs = 1;

    // Setup the spi for 8 bit data, high steady state clock
    spi.format(8,3);
    spi.frequency(1000000);

    // Select the device by seting chip select low
    cs = 0;
    spi.write(0x03);
    spi.write(Address >> 16  & 0xff);
    spi.write(Address >> 8   & 0xff);
    spi.write(Address        & 0xff);

    /*漢字ROMからデータを受信*/
    for (int i = 0; i < 16; i++) {
        matrixdata16[i] = spi.write(0x00);
    }
    // Deselect the device
    cs = 1;
}

/*シリアルモニタへ16*16のデータを表示する*/
void sendDotsToSerial32()
{
    /*上半分*/
    for (int i = 0; i < 8; i++) {
        for (int b = 0; b < 16; b++) {
            char byteDigit = (1 << i);
            if (matrixdata32[b] & byteDigit) {
                pc.printf("XX");
            } else {
                pc.printf("--");
            }
        }
        pc.printf("\r\n");
    }
    /*下半分*/
    for (int i = 0; i < 8; i++) {
        for (int b = 16; b < 32 ; b++) {
            char byteDigit = (1 << i);
            if (matrixdata32[b] & byteDigit) {
                pc.printf("XX");
            } else {
                pc.printf("--");
            }
        }
        pc.printf("\r\n");
    }
    pc.printf("\r\n");
} //sendDataToSerial32


/*シリアルモニタへ16*8のデータを表示する*/
void sendDotsToSerial16()
{
    /*上半分*/
    for (int i = 0; i < 8; i++) {
        for (int b = 0; b < 8; b++) {
            char byteDigit = (1 << i);
            if (matrixdata16[b] & byteDigit) {
                pc.printf("XX");
            } else {
                pc.printf("--");
            }
        }
        pc.printf("\r\n");
    }

    /*下半分*/
    for (int i = 0; i < 8; i++) {
        for (int b = 8; b < 16; b++) {
            char byteDigit = (1 << i);
            if (matrixdata16[b] & byteDigit) {
                pc.printf("XX");
            } else {
                pc.printf("--");
            }
        }
        pc.printf("\r\n");
    }
    pc.printf("\r\n");
} //sendDataToSerial32


/*1byteのSJISを表示する*/
void showSJIS1byte(uint8_t code)
{
    readFontASCII(code);
    sendDotsToSerial16();
}

/*2byteのSJISを表示する*/
//showSJIS2byte(SJIS文字コード)
void showSJIS2byte(unsigned short code)
{
    /*Arduinoのシリアルで日本語はSJIS送信なのでSJIS->JIS X 0208変換をする*/
    pc.printf("SJIS, 0x%x\r\n", code);
    uint8_t c1 = ((code & 0xff00) >> 8);
    uint8_t c2 = (code & 0xFF);
    if (c1 >= 0xe0) {
        c1 = c1 - 0x40;
    }
    if (c2 >= 0x80) {
        c2 = c2 - 1;
    }
    if (c2 >= 0x9e) {
        c1 = (c1 - 0x70) * 2;
        c2 = c2 - 0x7d;
    } else {
        c1 = ((c1 - 0x70) * 2) - 1;
        c2 = c2 - 0x1f;
    }
    /*読み出し*/
    readFontJIS(c1, c2);
    /*表示*/
    sendDotsToSerial32();
}

int main()
{
    while(1) {
        if (pc.readable() > 0) {
            /* PCからはSJISで送ること */
            wait(0.2);//最低でも2バイト受信したい
            uint8_t msbdata = pc.getc();//1バイト目 //10/07
            /*SJISの1バイトコードか否か*/
            if ( (msbdata < 0x80) || ((0xA0 < msbdata) && (msbdata <= 0xdF)) ) {
                showSJIS1byte(msbdata);
            } else {
                uint8_t lsbdata = pc.getc();//2バイト目 //10/07
                uint16_t data =  ((msbdata << 8) + lsbdata); //2
                showSJIS2byte(data);
            }
        }
    }
}
