#include "mbed.h"
#include "ESP8266Interface.h"
#include "TCPSocketConnection.h"

// You need to change these 4 lines.
#define SSID "YOUR SSID"
#define WIFIKEY "YOUR WIFI KEY"
const char EVENT[] = "YOUR IFTTT EVENT NAME";
const char KEY[] = "PUT YOUT IFTTT SECRET KEY HERE";
//

const char* ECHO_SERVER_ADDRESS = "54.243.120.63"; // maker.ifttt.com
const int ECHO_SERVER_PORT = 80;

ESP8266Interface wifi(p28,p27,p29,SSID,WIFIKEY,115200); // TX,RX,Reset,SSID,Password
RawSerial pc(USBTX, USBRX); // tx, rx
AnalogIn pot1 (p19);
AnalogIn pot2 (p20);
 
int main() {
    pc.baud(115200);
   
    int http_cmd_sz=800;
    char http_cmd[http_cmd_sz];
    
    wifi.init(); //Use DHCP
    wifi.connect();
    pc.printf("IP Address is %s\n", wifi.getIPAddress());
    
    TCPSocketConnection socket;
    while (socket.connect(ECHO_SERVER_ADDRESS, ECHO_SERVER_PORT) < 0) {
        pc.printf("Unable to connect to (%s) on port (%d)\n", ECHO_SERVER_ADDRESS, ECHO_SERVER_PORT);
        wait(1);
    }
    
    char Val1[6];
    char Val2[6];
    char Val3[6];
    snprintf(Val1,5,"%.2f", (float)pot1);
    snprintf(Val2,5,"%.2f", (float)pot2);
    
    snprintf(http_cmd, http_cmd_sz, "GET /trigger/%s/with/key/%s/?value1=%s&value2=%s&value3=%s HTTP/1.1\r\nHost: maker.ifttt.com\r\nConnection: close\r\n\r\n", EVENT, KEY, Val1, Val2, Val3);
    pc.printf(http_cmd);
    socket.send_all(http_cmd, sizeof(http_cmd) - 1);
    
    char buf[512];
    int n = socket.receive(buf, 512);
    buf[n] = '\0';
    pc.printf("%s\r\n", buf);
    
    socket.close();
    wifi.disconnect();
    
    while(true) {}
}
 