#include "mbed.h"
#include "DHT.h"
#include"Air_Quality.h"

AirQuality airqualitysensor;
int current_quality = -1;
PinName analogPin = A0;

DHT sensor(D3, DHT11);
InterruptIn motion(D2);
AnalogIn luminance(A1);

DigitalOut led_R(LED_RED);
DigitalOut led_G(LED_GREEN);
DigitalOut led_B(LED_BLUE);

int motion_detected = 0;

// Interrupt Handler
void AirQualityInterrupt()
{
    AnalogIn sensor(analogPin);
    airqualitysensor.last_vol = airqualitysensor.first_vol;
    airqualitysensor.first_vol = sensor.read()*1000;
    airqualitysensor.timer_index = 1;
}

void irq_handler(void)
{
    motion_detected = 1;
}

int main()
{
    int error = 0;
    float hum = 0.0f;
    float cel = 0.0f;
    
    airqualitysensor.init(analogPin, AirQualityInterrupt);
    
    int cnt = 0;
    motion.rise(&irq_handler);
    
    while(1)
    {
        wait(0.1);
        error = sensor.readData();
        
        if (0 == error) {
            hum = sensor.ReadHumidity();
            cel = sensor.ReadTemperature(CELCIUS);
            printf(" 1. Humidity : %4.2f\r\n\n", hum);
            printf(" 2. Temperature in Celcius : %2.2f\r\n\n", cel);
            
            {
                if (hum > 70) {  // if celcius is higher than 28, LED_RED on.
                    led_R = 0;   // LED_RED on
                    led_B = 1;   // LED_BLUE off
                }
                else{ 
                    led_R = 1;   // LED_RED off
                    led_B = 0;   // LED_BLUE on
                }
            }
            {
                if(cel > 28) {  // if celcius is higher than 28, LED_RED on.
                    led_R = 0;   // LED_RED on
                    led_B = 1;   // LED_BLUE off
                }
                else { 
                    led_R = 1;   // LED_RED off
                    led_B = 0;   // LED_BLUE on
                }
            }
        }
        else {
            printf("Error : %d\n", error);
        }
        
        if(motion_detected) {
            cnt++;
            motion_detected = 0;
            /*led_R = 1;
            led_G = 1;
            led_B = 1;*/
            
            printf("3. Something move%d\r\n\n", cnt);
            wait(0.1); 
        }
        
        if(luminance.read()){
            
            if(0.1<=luminance.read()&&luminance.read()<=0.3){
                led_R=0; led_G=0; led_B=1;}   // yellow LED on
                
            else{
                led_R=1; led_G=1; led_B=1;}   // led off
             
            printf("4. Luminance: %f\r\n\n", luminance.read());    
            wait(0.1);
        }
        else {
            led_R=0; led_G=0; led_B=0;    // white LED on 
            printf("4. Luminance: %f\r\n\n", luminance.read());
            wait(0.1);         
        }
        //air quality sensor
        current_quality=airqualitysensor.slope();
        if (current_quality >= 0) { // if a valid data returned.
            if (current_quality == 0){
                printf("5. High pollution! Force signal active\n\r\n");
               // led1 = 0;
               // led2 = 1;
            }
            else if (current_quality == 1){
                printf("5. High pollution!\n\r\n");
              //  led1 = 0;
               // led2 = 1;
            }
            else if (current_quality == 2){
                printf("5. Low pollution!\n\n\r");
              //  led1 = 0;
              //  led2 = 1;
            }
            else if (current_quality == 3){
                printf("5. Fresh air\n\r\n");
              //  led1 = 1;
              //  led2 = 0;
            } 
        }
        
    }
}
/*
AnalogIn luminance(A0);
InterruptIn motion(D2);

DigitalOut RED(LED1, 1);
DigitalOut GREEN(LED2, 1);
DigitalOut BLUE(LED3, 1);

int motion_detected = 0;

void irq_handler(void)
{
    motion_detected = 1;
}

int main()
{
    int cnt = 0;
    motion.rise(&irq_handler);
    
    while (true) {
        
        //grove motion sensor
        if(motion_detected) {
            cnt++;
            motion_detected = 0;
            RED = 0;
            GREEN = 1;
            BLUE = 1;
            wait(1);
            printf("Something move%d\r\n", cnt);
        }
         
        //luminance sensor
        if(luminance.read()){
            
            if(0.1<=luminance.read()&&luminance.read()<=0.3){
                RED=0; GREEN=0; BLUE=1;}   // yellow LED on
                
            else{
                RED=1; GREEN=1; BLUE=1;}   // led off
             
            printf("Luminance: %f\r\n", luminance.read());    
            wait(0.5f);
        }
        else {
            RED=0; GREEN=0; BLUE=0;    // white LED on 
            printf("Luminance: %f\r\n", luminance.read());
            wait(0.5f);         
        }
                    
    }
}*/
/*
InterruptIn motion(D2);

DigitalOut RED(LED1, 1);
DigitalOut GREEN(LED2, 1);
DigitalOut BLUE(LED3, 1);

int motion_detected = 0;

void irq_handler(void)
{
    motion_detected = 1;
}

int main()
{
    int cnt = 0;
    motion.rise(&irq_handler);
    
    while (true) {
        
        //grove motion sensor
        if(motion_detected) {
            cnt++;
            motion_detected = 0;
            RED = 0;
            GREEN = 1;
            BLUE = 1;
            wait(1);
            printf("Something move%d\r\n", cnt);
        }
                    
    }
}*/