// Set 1 if use this main program.
// I recommend to copy and paste this template to your main.cpp. 
// And your main function in your main.cpp generated by server must be deleted.

#if 0 
#include "mbed.h"

/**
 * RTno_Template.pde
 * RTno is RT-middleware and arduino.
 *
 * Using RTno, arduino device can communicate any RT-components 
 *  through the RTno-proxy component which is launched in PC.
 * Connect arduino with USB, and program with RTno library.
 * You do not have to define any protocols to establish communication
 *  between arduino and PC.
 *
 * Using RTno, you must not define the function "setup" and "loop".
 * Those functions are automatically defined in the RTno libarary.
 * You, developers, must define following functions:
 *  int onInitialize(void);
 *  int onActivated(void);
 *  int onDeactivated(void);
 *  int onExecute(void);
 *  int onError(void);
 *  int onReset(void);
 * These functions are spontaneously called by the RTno-proxy
 *  RT-component which is launched in the PC.
 * @author Yuki Suga
 * This code is written/distributed for public-domain.
 */

#include <RTno.h>

/**
 * This function is called at first.
 * conf._default.baudrate: baudrate of serial communication
 * exec_cxt.periodic.type: reserved but not used.
 */
void rtcconf(config_str& conf, exec_cxt_str& exec_cxt) {
  // If you want to use Serial Connection, configure below:
   conf._default.connection_type = ConnectionTypeSerialUSB; // USBTX & USBRX (In Windows, Driver must be updated.)
   //conf._default.connection_type = ConnectionTypeSerial1; // pin9=tx, pin10=rx
   //conf._default.connection_type = ConnectionTypeSerial2; // pin13=tx, pin14=rx
   //conf._default.connection_type = ConnectionTypeSerial3; // pin28=tx, pin27=rx
   conf._default.baudrate = 57600; // This value is required when you select ConnectionTypeSerial*
  
  // If you want to use EthernetTCP, configure below:
  //conf._default.connection_type = ConnectionTypeEtherTcp;
  //conf._default.port = 23;
  //conf._default.mac_address = MACaddr(0xDE, 0xAD, 0xBE, 0xEF, 0xFE, 0xED);
  //conf._default.ip_address = IPaddr(192,168,42,100);
  //conf._default.subnet_mask = IPaddr(255,255,255,0);
  //conf._default.default_gateway = IPaddr(192,168,42,254);
   exec_cxt.periodic.type = ProxySynchronousExecutionContext;
   //exec_cxt.periodic.type = Timer1ExecutionContext; // onExecute is called by Timer1. Period must be specified by 'rate' option.
   exec_cxt.periodic.rate = 100; // [Hz] This option is indispensable when type is Timer*ExecutionContext.
}


/** 
 * Declaration Division:
 *
 * DataPort and Data Buffer should be placed here.
 *
 * available data types are as follows:
 * TimedLong
 * TimedDouble
 * TimedFloat
 * TimedLongSeq
 * TimedDoubleSeq
 * TimedFloatSeq
 *
 * Please refer following comments. If you need to use some ports,
 * uncomment the line you want to declare.
 **/
TimedLong in0;
InPort<TimedLong> in0In("in0", in0);
///TimedLong in1;
//InPort<TimedLong> in1In("in1", in1);
//TimedLongSeq in0;
//InPort<TimedLongSeq> in0In("in0", in0);

TimedLong out0;
OutPort<TimedLong> out0Out("out0", out0);
//TimedLongSeq<TimedLongSeq> out0;
//OutPort out0Out("out0", out0);

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

DigitalIn  sw1(p21);
//////////////////////////////////////////
// on_initialize
//
// This function is called in the initialization
// sequence. The sequence is triggered by the
// PC. When the RTnoRTC is launched in the PC,
// then, this function is remotely called
// through the USB cable.
// In on_initialize, usually DataPorts are added.
//
//////////////////////////////////////////
int RTno::onInitialize() {
  /* Data Ports are added in this section.

  addInPort(in1In);
  addOutPort(out0Out);
  addOutPort(out1Out);
  */
  
  addInPort(in0In);
  //addInPort(in1In);
  addOutPort(out0Out);
  led1 = 1;
  led2 = 0;
  led3 = 0;
  led4 = 0;
  sw1.mode(PullUp);
  // Some initialization (like port direction setting)
  // int LED = 13;
  // pinMode(LED, OUTPUT);

  return RTC_OK; 
}

////////////////////////////////////////////
// on_activated
// This function is called when the RTnoRTC
// is activated. When the activation, the RTnoRTC
// sends message to call this function remotely.
// If this function is failed (return value 
// is RTC_ERROR), RTno will enter ERROR condition.
////////////////////////////////////////////
int RTno::onActivated() {
  // Write here initialization code.
  led2 = 1;
  led3 = 0;
  led4 = 0;
  return RTC_OK; 
}

/////////////////////////////////////////////
// on_deactivated
// This function is called when the RTnoRTC
// is deactivated.
/////////////////////////////////////////////
int RTno::onDeactivated()
{
  // Write here finalization code.
  led2 = 0;
  led3 = 0;
  led4 = 0;
  return RTC_OK;
}

//////////////////////////////////////////////
// This function is repeatedly called when the 
// RTno is in the ACTIVE condition.
// If this function is failed (return value is
// RTC_ERROR), RTno immediately enter into the 
// ERROR condition.r
//////////////////////////////////////////////
int RTno::onExecute() {
  /**
   * Usage of InPort with premitive type.
   */
  if(in0In.isNew()) {
    in0In.read();
    led4 = in0.data > 0 ? 1 : 0;
  } 
  
  //if(in1In.isNew()) {
  //  in1In.read();
  //  led4 = in1.data;
  //} 
  
  /**
   * Usage of InPort with sequence type
  if(in0In.isNew(&in1In)) {
    in0In.read();
    for(int i = 0;i < in0.data.length;i++) {
      long data_buffer = in0.data[i];
    }
  }
  */
  
  /**
   * Usage of OutPort with primitive type.
  out0.data = 3.14159;
  out0Out.write();
  */
  out0.data = sw1;
  out0Out.write();
  
  /**
   * Usage of OutPort with sequence type.
  out0.data.length(3);
  out0.data[0] = 1.1;
  out0.data[1] = 2.2;
  out0.data[2] = 3.3;
  out0Out.write();
  */
    
  return RTC_OK; 
}


//////////////////////////////////////
// on_error
// This function is repeatedly called when
// the RTno is in the ERROR condition.
// The ERROR condition can be recovered,
// when the RTno is reset.
///////////////////////////////////////
int RTno::onError()
{
  return RTC_OK;
}

////////////////////////////////////////
// This function is called when 
// the RTno is reset. If on_reset is
// succeeded, the RTno will enter into
// the INACTIVE condition. If failed 
// (return value is RTC_ERROR), RTno
// will stay in ERROR condition.ec
///////////////////////////////////////
int RTno::onReset()
{
  return RTC_OK;
}


#endif
