#define RTNO_SUBMODULE_DEFINE

#include "mbed.h"
#include "UART.h"

#define UART_RX_BUFFER_SIZE 64

static Serial *m_pSerial;
unsigned char uart_rx_buffer[UART_RX_BUFFER_SIZE];
int uart_rx_buffer_pointer_head = 0;
int uart_rx_buffer_pointer_tail = 0;


/**
 * Push data to ring buffer.
 */
int uart_rx_buffer_push(unsigned char* c) {
    uart_rx_buffer[uart_rx_buffer_pointer_tail] = *c;
    uart_rx_buffer_pointer_tail++;
    if(uart_rx_buffer_pointer_tail >= UART_RX_BUFFER_SIZE) {
        uart_rx_buffer_pointer_tail = 0;
    }
    return 0;
}



/**
 * Pop data fron ring buffer
 */
int uart_rx_buffer_pop(unsigned char *c) {
    *c = uart_rx_buffer[uart_rx_buffer_pointer_head];
    uart_rx_buffer_pointer_head++;
    if(uart_rx_buffer_pointer_head >= UART_RX_BUFFER_SIZE) {
        uart_rx_buffer_pointer_head = 0;
    }
    return 0;
}

int uart_rx_buffer_get_size() {
    int size = uart_rx_buffer_pointer_tail - uart_rx_buffer_pointer_head;
    if(size < 0) {
        size += UART_RX_BUFFER_SIZE;
    }
    return size;
}

void rx_isr(void) {
    int8_t c = m_pSerial->getc();
    uart_rx_buffer_push((uint8_t*)&c);
}



void UART_init(unsigned char num, unsigned long baudrate)
{
    PinName rx, tx;
    switch(num) {
    case 0:
      rx = USBRX; tx = USBTX;
      break;
    case 1:
      tx = p9, rx = p10;
      break;
    case 2:
      tx = p13, rx = p14;
      break;
    case 3:
      tx = p28, rx = p27;
      break;
    }
    
    m_pSerial = new Serial(tx, rx);
    m_pSerial->baud(baudrate);
    m_pSerial->attach(rx_isr, Serial::RxIrq);

    SerialDevice_putc = UART_putc;
    SerialDevice_getc = UART_getc;
    SerialDevice_available = UART_available;
}

void UART_putc(const char c) {
  while(!m_pSerial->writeable()) {
    wait_us(100);
  }
  m_pSerial->putc(c);
}

uint8_t UART_available()
{
    return uart_rx_buffer_get_size();
}


uint8_t UART_getc()
{
    unsigned char c;
    uart_rx_buffer_pop(&c);
    return c;
}
