#include "mbed.h"
#include "SerialDevice.h"

// static value declaration.
void(*SerialDevice_putc)(const char c);
uint8_t(*SerialDevice_available)();
uint8_t(*SerialDevice_getc)();

int32_t INFINITE = -1;

#if 1
static Timer timer;
#endif

int8_t SerialDevice_read(uint8_t* buffer, const uint8_t size, const int32_t &wait_usec)
{
  int32_t us;
  timer.reset();
  timer.start();
  for(unsigned int i = 0;i < size;i++) {
    while (1) {
      if(SerialDevice_available() > 0) {
        break;
      }
      us = timer.read_us();
      if (us >= wait_usec && wait_usec != INFINITE) {
        timer.stop();
        return -TIMEOUT;
      }
    }
    buffer[i] = SerialDevice_getc();
  }
  timer.stop();
  return size;
}


