#include "mbed.h"
#define RTNO_SUBMODULE_DEFINE
#include "RTno.h"

#ifdef USE_ETHERNET_CONNECTION

#include "EtherTcp.h"
#include "EthernetInterface.h"


#include "ip_addr.h"
/**
#include <../SPI/SPI.h>
#include <../Ethernet/Ethernet.h>

static EthernetServer *m_pServer;
static EthernetClient *m_pClient;
*/
//static EthernetInterface* m_pInterface;
static TCPSocketServer* m_pServerSocket;
static TCPSocketConnection m_ClientSocket;


#define ETCP_RX_BUFFER_SIZE 128
uint8_t etcp_rx_buffer[ETCP_RX_BUFFER_SIZE];
int etcp_rx_buffer_pointer_head = 0;
int etcp_rx_buffer_pointer_tail = 0;
///Host m_Client;

Serial *pSerial;

/**
 * Push data to ring buffer.
 */
int etcp_rx_buffer_push(unsigned char c) {
    etcp_rx_buffer[etcp_rx_buffer_pointer_tail] = c;
    etcp_rx_buffer_pointer_tail++;
    if(etcp_rx_buffer_pointer_tail >= ETCP_RX_BUFFER_SIZE) {
        etcp_rx_buffer_pointer_tail = 0;
    }
    return 0;
}

/**
 * Pop data fron ring buffer
 */
int etcp_rx_buffer_pop(unsigned char *c) {
    *c = etcp_rx_buffer[etcp_rx_buffer_pointer_head];
    etcp_rx_buffer_pointer_head++;
    if(etcp_rx_buffer_pointer_head >= ETCP_RX_BUFFER_SIZE) {
        etcp_rx_buffer_pointer_head = 0;
    }
    return 0;
}

int etcp_rx_buffer_get_size() {
    int size = etcp_rx_buffer_pointer_tail - etcp_rx_buffer_pointer_head;
    if(size < 0) {
        size += ETCP_RX_BUFFER_SIZE;
    }
    return size;
}

/*
static void EtherTcp_onClientEvent(TCPSocketEvent e) {
  switch (e) {
  // If the socket is readable, do stuff
  case TCPSOCKET_READABLE:
    while(1) {
      char buf;
      int ret = m_pClientSocket->recv(&buf, 1);
      if (ret == 0) break;
      etcp_rx_buffer_push(buf);
    }
    
    break;
  case TCPSOCKET_CONTIMEOUT:
  case TCPSOCKET_CONRST:
  case TCPSOCKET_CONABRT:
  case TCPSOCKET_ERROR:
  case TCPSOCKET_DISCONNECTED:
    delete m_pClientSocket;
    m_pClientSocket = NULL;
    break;
  }
}

static void EtherTcp_onServerEvent(TCPSocketEvent e) {
  if(e == TCPSOCKET_ACCEPT ) {
    if ( m_pServerSocket->accept(&m_Client, &m_pClientSocket) ) {
      return; //Error in accept, discard connection
    }
    
    m_pClientSocket->setOnEvent(EtherTcp_onClientEvent);
  }
}
*/

void EtherTcp_init(/*const char* mac, */const char* ip, 
           const char* gateway, const char* subnet,
           uint16_t port) 

{
  pSerial = new Serial(USBTX, USBRX);
  EthernetInterface::init(
       ip, subnet, gateway);
  //printf("Hello %d %d %d %d\r\n", ip[0], ip[1], ip[2], ip[3]);
  //EthernetErr ethErr = m_pInterface->setup();
  //if (ethErr) {
 //  return;
 // }  
  
  m_pServerSocket = new TCPSocketServer();
  //m_pServerSocket->setOnEvent(EtherTcp_onServerEvent);
  m_pServerSocket->bind(port);
  m_pServerSocket->listen();
  m_pServerSocket->accept(m_ClientSocket);
  SerialDevice_available = EtherTcp_available;
  SerialDevice_getc = EtherTcp_getc;
  SerialDevice_putc = EtherTcp_putc;
}

uint8_t EtherTcp_available()
{
  //Net::poll();
  return etcp_rx_buffer_get_size();
}


void EtherTcp_putc(const char c) {
  char d = c;
    m_ClientSocket.send(&d, 1);
  }

uint8_t EtherTcp_getc()
{
  uint8_t c;
  m_ClientSocket.receive((char*)&c, 1);
  //etcp_rx_buffer_pop(&c);
  return c;
}

#endif