#define RTNO_SUBMODULE_DEFINE

#include <stdint.h>
#include "RTno.h"
#include "Packet.h"
#include "Timer1ExecutionContext.h"
//#include <avr/io.h>
//#include <avr/interrupt.h>

static float m_Period;
//static uint8_t m_ClockSetting;

Ticker *m_pTimer;

void Timer1EC_start();
void Timer1EC_suspend();
void Timer1EC_resume();

void tick () {
    EC_execute();
}


void Timer1EC_init(double rate)
{
  EC_init(0x22);
  m_pTimer = new Ticker();
  // Initialize Period
  m_Period = (1.0 / rate);
  EC_start = Timer1EC_start;
  EC_suspend = Timer1EC_suspend;
  EC_resume = Timer1EC_resume;
}

void Timer1EC_start()
{
    m_pTimer->attach(tick, m_Period);
}

void Timer1EC_suspend()
{
    m_pTimer->detach();
}

void Timer1EC_resume()
{
    Timer1EC_start();
}


