#include "mbed.h"
DigitalIn button(P0_1, PullUp); //按键myled3改变状态
//adc采集电压函数
float meas;    
long ADC_VALUE[3]; 
AnalogIn ADC_MQ2(P0_6);       //ADC1，MQ2空气质量检测
AnalogIn ADC_MQ3(P0_14);      //ADC2，MQ2空气质量检测
AnalogIn analog_value(P0_23); // ADC3，可调电位器

void adc_data()
{
        meas = ADC_MQ2.read(); 
        ADC_VALUE[0] = (long)(meas * 3300);       
        meas = ADC_MQ3.read(); 
        ADC_VALUE[1] = (long)(meas * 3300); 
        meas = analog_value.read();
        ADC_VALUE[2] = (long)(meas * 3300);      
}

//oled显示函数
#include "CriusOLED.h"
DigitalOut myled1(P0_27);
DigitalOut myled2(P0_13);
DigitalOut myled3(P0_17);  //用户led
Ticker ticker;
float sampleTime = 1.0;
long times;
char buffer1[40];
char buffer2[20];
char buffer3[20];
char Buffer[100];
#define  bufferclear  "                "
void am2320_dat();
void bme280_dat();
void Tlink_Tcp();
void oled_ticker() 
{
        //每隔一秒显示一次
        myled1=!myled1;
        if(!button)
        myled3=!myled3;
        adc_data();
        sendStrXY(bufferclear,1,0);  
        snprintf(buffer1,sizeof(buffer1), "%ds %dmV %dmV %dmV",times++,ADC_VALUE[0],ADC_VALUE[1],ADC_VALUE[2]); 
        sendStrXY(buffer1,0,0);  
        am2320_dat();
        bme280_dat();
}

void oled_init()
{
    i2c.frequency(400000);
    init_OLED();
    displayOn();
    reset_display(); 
    ticker.attach(&oled_ticker, sampleTime);  
}

//AM2320初始化
#include  "AM2320.h"
AM2320 am2320(i2c);
int h;
int t;
void am2320_dat()
{
    h = am2320.humidity();
    t = am2320.temperature();
    snprintf(buffer2,sizeof(buffer2), "%2d.%dc %2d.%d%%",t/10,t%10,h/10,h%10);
    sendStrXY(buffer2,4,0); 
}

#include "BME280.h"
BME280 sensor(I2C_SDA, I2C_SCL);
void bme280_dat()
{
  snprintf(buffer3,sizeof(buffer3), "%2.2fC %6.0fPa",sensor.getTemperature(), sensor.getPressure()*100); 
  sendStrXY(buffer3,5,0); 
}

Serial pc(P0_4,P0_0,921600);
//w5500初始化函数
#include "WIZnetInterface.h"
#define USE_DHCP    1

#define LOOPBACKPORT    80
char * IP_Addr    = "192.168.0.194";
char * IP_Subnet  = "255.255.255.0";
char * IP_Gateway = "192.168.0.1";
unsigned char MAC_Addr[6] = {0x00,0x08,0xDC,0x12,0x34,0x56};


SPI spi(P0_26,P0_25,P0_24);
WIZnetInterface ethernet(&spi,P0_16,P0_5);

void W5500_init()
{
        #if USE_DHCP
        int ret = ethernet.init(MAC_Addr);
        #else
        int ret = ethernet.init(MAC_Addr,IP_Addr,IP_Subnet,IP_Gateway);
        #endif
        myled2=1; 
        if (!ret) {
            pc.printf("Initialized, MAC: %s\r\n", ethernet.getMACAddress());
            ret = ethernet.connect();
            if (!ret) {
                pc.printf("IP: %s, MASK: %s, GW: %s\r\n",
                          ethernet.getIPAddress(), ethernet.getNetworkMask(), ethernet.getGateway());
                sendStrXY("IP:",2,0); 
                sendStrXY(ethernet.getIPAddress(),2,3);            
            } else {
                pc.printf("Error ethernet.connect() - ret = %d\r\n", ret);
                exit(0);
            }
        } else {
            pc.printf("Error ethernet.init() - ret = %d\r\n", ret);
            exit(0);
        }       
}

void w5500_httpserver()
{
  char buffer[128];
  W5500_init();
  TCPSocketServer server;    
  server.bind(LOOPBACKPORT);
  server.listen();
  while (1) {
            pc.printf("\nWait for new connection...\r\n");
            TCPSocketConnection client;
            server.accept(client);
            client.set_blocking(false, 0); 
            pc.printf("Connection from: %s\r\n", client.get_address());
            sendStrXY("C:",3,0);  
            sendStrXY(client.get_address(),3,3); 
            while (client.is_connected() == true) {
                myled2=0;  
                int n = client.receive(buffer, sizeof(buffer));
                if(n > 0)
                {
                    //client.send_all(buffer, n); //将接受的数据发送回去
                    if(strstr(buffer,"AD"))
                      client.send(buffer1, sizeof(buffer1));  
                    
                    if(strstr(buffer,"AM"))
                      client.send_all(buffer2, sizeof(buffer2));                      
 
                    if(strstr(buffer,"BE"))
                      client.send(buffer3, sizeof(buffer3));  
                    
                    if(strstr(buffer,"LED"))
                      myled3=!myled3;
                    
                    if(strstr(buffer,"ALL"))
                    {
                        snprintf(Buffer,sizeof(Buffer), " %s\r\n %s\r\n %s\r\n ledstatus:%d\r\n",buffer1,buffer2,buffer3,!myled3);
                        client.send(Buffer, sizeof(Buffer));                     
                    }                              

                    if(strstr(buffer,"IP"))
                    {
                        snprintf(Buffer,sizeof(Buffer), " MAC_Addr: %s\r\n LocalIp: %s\r\n ClientIp: %s\r\n",ethernet.getMACAddress(),ethernet.getIPAddress(),client.get_address());
                        client.send(Buffer, sizeof(Buffer));                     
                    }                                                            
                }
                if(client.is_fin_received())
                    client.close();
            }
            pc.printf("Disconnected.\r\n");
            sendStrXY(bufferclear,3,0); 
            //sendStrXY(bufferclear,7,0); 
            myled2=1; 
        }   
}



int main() {   
    pc.printf("Start\r\n");
    oled_init();
    wait(5);
    while(1)
    {
      w5500_httpserver();
    }
}
