/* ============================================
Modified Code from Crius
The CriusOLED Hardware MUST be modified for correct function of ACK
Copyright (c) 2014 Michael Ruck michael@ruck.com

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
===============================================
*/
#include "./data.h"
#define OLED_ADDR    (0x78)

I2C i2c(I2C_SDA, I2C_SCL);

void displayOn(void);
void displayOff(void);
void SendByte(unsigned char data);
void sendcommand(unsigned char com);
void SendByte(unsigned char com);
void printBigNumber(unsigned char s, int X, int Y);
void SendByteXY(unsigned char data, int X, int Y);


//==========================================================//
// Turns display on.
void displayOn(void)
{
    sendcommand(0xaf);        //display on
}

//==========================================================//
// Turns display off.
void displayOff(void)
{
    sendcommand(0xae);        //display off
}
//==========================================================//
// Actually this sends a byte, not a char to draw in the display.
// Display's chars uses 8 byte font the small ones and 96 bytes
// for the big number font.
void SendByte(unsigned char data)
{
    //Create a temporary buffer
    char buff[2];

    //Load the control byte and 8-bit data
    buff[0] = (0x40);
    buff[1] = data;

    //Write the data
    i2c.write(OLED_ADDR, buff, 2);

}

//==========================================================//
// Used to send commands to the display.
void sendcommand(unsigned char com)
{
    //Create a temporary buffer
    char buff[2];

    //Load the control byte and 8-bit command
    buff[0] = 0x00;
    buff[1] = com;

    //Write the command
    i2c.write(OLED_ADDR, buff, 2);
}
//==========================================================//
// Set the cursor position in a 16 COL * 8 ROW map.
void setXY(unsigned char row,unsigned char col)
{
    sendcommand(0xb0+row);                //set page address
    sendcommand(0x00+(8*col&0x0f));       //set low col address
    sendcommand(0x10+((8*col>>4)&0x0f));  //set high col address
}
//==========================================================//
// Clears the display by sendind 0 to all the screen map.
void clear_display(void)
{
    unsigned char i,k;
    for(k=0; k<8; k++) {
        setXY(k,0);
        {
            for(i=0; i<128; i++) { //clear all COL
                SendByte(0);         //clear all COL
                //delay(10);
            }
        }
    }
}
//==========================================================//
// Resets display depending on the actual mode.
void reset_display(void)
{
    displayOff();
    clear_display();


    displayOn();
}
//==========================================================//

void sendImage()
{
    reset_display();
    for(int i=0; i<128*8; i++)   // show 128* 64 Logo
        SendByte(logo[i]);

}
//==========================================================//
void printBigTime(char *s)
{

    int Y=0;
    int lon = strlen(s);
    if(lon == 3) {
        Y = 0;
    } else if (lon == 2) {
        Y = 3;
    } else if (lon == 1) {
        Y = 6;
    }

    int X = 2;
    while(*s) {
        printBigNumber(*s, X, Y);

        Y+=3;
        X=2;
        setXY(X,Y);
        *s++;
    }
}


//==========================================================//
// Prints a display big number (96 bytes) in coordinates X Y,
// being multiples of 8. This means we have 16 COLS (0-15)
// and 8 ROWS (0-7).
void printBigNumber(unsigned char s, int X, int Y)
{
    setXY(X,Y);
    int salto=0;
    for(int i=0; i<96; i++) {
        if(s == ' ') {
            SendByte(0);
        } else
            SendByte(bigNumbers[s-0x30][i]);

        if(salto == 23) {
            salto = 0;
            X++;
            setXY(X,Y);
        } else {
            salto++;
        }
    }
}
//==========================================================//
// Prints a display char (not just a byte) in coordinates X Y,
// being multiples of 8. This means we have 16 COLS (0-15)
// and 8 ROWS (0-7).
void SendByteXY(unsigned char data, int X, int Y)
{
    i2c.start();
    i2c.write(OLED_ADDR);
    i2c.write(0x40);

    for(int i=0; i<8; i++)
        i2c.write((int)(myFont[data-0x20]+i)); // <<-------------------------------------

    i2c.stop();     // stop transmitting
}
//==========================================================//
// Prints a string regardless the cursor position.
void sendStr(unsigned char *s)
{
    unsigned char i=0;
    while(*s) {
        for(i=0; i<8; i++) {
            SendByte(myFont[*s-0x20][i]);
        }
        *s++;
    }
}
//==========================================================//
// Prints a string in coordinates X Y, being multiples of 8.
// This means we have 16 COLS (0-15) and 8 ROWS (0-7).
void sendStrXY( char *s, int X, int Y)
{
    setXY(X,Y);
    unsigned char i=0;
    while(*s) {
        for(i=0; i<8; i++) {
            SendByte(myFont[*s-0x20][i]);
        }
        *s++;
    }
}


//==========================================================//
// Inits oled and draws logo at startup
void init_OLED(void)
{
    sendcommand(0xae);        //display off
    sendcommand(0xa6);            //Set Normal Display (default)
    // Adafruit Init sequence for 128x64 OLED module
    sendcommand(0xAE);             //DISPLAYOFF
    sendcommand(0xD5);            //SETDISPLAYCLOCKDIV
    sendcommand(0x80);            // the suggested ratio 0x80
    sendcommand(0xA8);            //SSD1306_SETMULTIPLEX
    sendcommand(0x3F);
    sendcommand(0xD3);            //SETDISPLAYOFFSET
    sendcommand(0x0);             //no offset
    sendcommand(0x40 | 0x0);      //SETSTARTLINE
    sendcommand(0x8D);            //CHARGEPUMP
    sendcommand(0x14);
    sendcommand(0x20);             //MEMORYMODE
    sendcommand(0x00);             //0x0 act like ks0108

    sendcommand(0xA0 | 0x1);      //SEGREMAP   //Rotate screen 180 deg
    //sendcommand(0xA0);

    sendcommand(0xC8);            //COMSCANDEC  Rotate screen 180 Deg
    //sendcommand(0xC0);

    sendcommand(0xDA);            //0xDA
    sendcommand(0x12);           //COMSCANDEC
    sendcommand(0x81);           //SETCONTRAS
    sendcommand(0xCF);           //
    sendcommand(0xd9);          //SETPRECHARGE
    sendcommand(0xF1);
    sendcommand(0xDB);        //SETVCOMDETECT
    sendcommand(0x40);
    sendcommand(0xA4);        //DISPLAYALLON_RESUME
    sendcommand(0xA6);        //NORMALDISPLAY

    clear_display();
    sendcommand(0x2e);            // stop scroll
    //----------------------------REVERSE comments----------------------------//
    //  sendcommand(0xa0);        //seg re-map 0->127(default)
    //  sendcommand(0xa1);        //seg re-map 127->0
    //  sendcommand(0xc8);
    //  delay(1000);
    //----------------------------REVERSE comments----------------------------//
    // sendcommand(0xa7);  //Set Inverse Display
    // sendcommand(0xae);     //display off
    sendcommand(0x20);            //Set Memory Addressing Mode
    sendcommand(0x00);            //Set Memory Addressing Mode ab Horizontal addressing mode
    //  sendcommand(0x02);         // Set Memory Addressing Mode ab Page addressing mode(RESET)

    setXY(0,0);

    sendcommand(0xaf);        //display on
}
