#include "mbed.h"
#include "uLCD_4DGL.h"
#include "SparkfunAnalogJoystick.h"

DigitalOut myled(LED1);
Serial pc(USBTX, USBRX);
Serial xbee(p9,p10);
DigitalOut reset(p22);
uLCD_4DGL uLCD(p28,p27,p21); // serial tx, serial rx, reset pin;
SparkfunAnalogJoystick JOYSTICK(p15,p16,p17);
DigitalIn pb(p8);

int getFirstOpenTile(int[]);
void highlightCurrentTile(int,int);
int getJoystickDirection(void);
int getNewTile(int,int);
int checkGameOver(int[]);
void handleGameOver(int);
int read_num(bool);
int convert_to_int(char[],int);
void draw_x(int);
void background_color(int);
void line(int,int,int,int,int);
void circle(int,int,int,int);
void filled_circle(int,int,int,int);
void triangle(int,int,int,int,int,int,int);
void rectangle(int,int,int,int,int);
void filled_rectangle(int,int,int,int,int);
void pixel(int,int,int);
void cls(void);
void locate(int,int);
void putc(char);
void textbackground_color(int);

int main() {
    reset=0;
    wait_ms(1);
    reset=1;
    wait_ms(1);
//    uLCD.baudrate(3000000);
    pc.printf("Starting sender.\r\n");
    char c;
    
    // Initial connection
    while(1){
        if(xbee.writeable()){
            xbee.putc('o');
            wait(0.5);
        }
        if(xbee.readable()){
            c = xbee.getc();
            if(c == 'o'){
                uLCD.cls();
                uLCD.printf("Connected!");
                break;
            }
            else{
                uLCD.cls();
                uLCD.printf("Received but not right");  
            }
        }
        else{
            uLCD.cls();
            uLCD.printf("Connecting with receiver...");
        }
    }
    wait(3);
    
    // Start game and initialize variables
    // 'O' = 1
    // 'X' = 10
    int board[9] = {};
    int currentPlayer = 1;
    int currentTile = 0;
    int p1jd = 0;
    int p2jd = 0;
    int p1b = 0;
    int p2b = 0;
    int gameOver = 0;
    cls();
    line(0, 42 , 127, 42 , 0xFF0000);
    line(0, 84 , 127, 84 , 0xFF0000);
    line(42, 0 , 42, 127, 0xFF0000);
    line(84, 0, 84, 127, 0xFF0000);
    pb.mode(PullUp);
    
    while(1) {
        // Player 1's turn
        currentTile = getFirstOpenTile(board);
        highlightCurrentTile(currentTile, BLUE);
        while(currentPlayer == 1) {
            p1jd  = getJoystickDirection();
            if(pb){
                p1b = 0;
            }
            else{
                p1b = 1;
            }
            if(p1b == 1) {
                if(board[currentTile] == 0){
                    board[currentTile] = 1;
                    int i = currentTile/3;
                    int j = currentTile%3;
                    highlightCurrentTile(currentTile, BLACK);
                    circle(42*j+21, 42*i+21, 19, BLUE);
                    currentPlayer = 2;
                    xbee.printf("m,");  
                    break;  
                }
                else {
                    //error sound?    
                }
            }
            if( p1jd != 0) {
                highlightCurrentTile(currentTile, BLACK);
                currentTile = getNewTile(p1jd, currentTile);
                highlightCurrentTile(currentTile, BLUE);
                wait(0.25);
            }
        }
        gameOver = checkGameOver(board);
        if(gameOver > 0) {
            handleGameOver(gameOver);
            break;
        }
        // Player 2's turn
        currentTile = getFirstOpenTile(board);
        highlightCurrentTile(currentTile, GREEN);
        while(currentPlayer == 2){
            if(xbee.readable()){
                p2jd = read_num(true);
                p2b = read_num(true);
                if(p2b == 1) {
                    if(board[currentTile] == 0){
                        board[currentTile] = 10;
                        int i = currentTile/3;
                        int j = currentTile%3;
                        highlightCurrentTile(currentTile, BLACK);
                        draw_x(currentTile);
                        currentPlayer = 1;
                        xbee.printf("m");
                        break;   
                    }
                    else {
                        //error sound?    
                    }
                }
                if( p2jd != 0) {
                    highlightCurrentTile(currentTile, BLACK);
                    currentTile = getNewTile(p2jd, currentTile);
                    highlightCurrentTile(currentTile, GREEN);
                    wait(0.25);
                }
            }
        }
        gameOver = checkGameOver(board);
        if(gameOver > 0) {
            handleGameOver(gameOver);
            break;
        }
    }
}

int getFirstOpenTile(int board[]) {
    for(int i = 0; i < 9; i++){
        if(board[i] == 0){
            return i;
        }       
    }
    return -1;
}
void highlightCurrentTile(int tile, int color){ 
        int i = tile/3;
        int j = tile%3;
        filled_circle(42*j+21, 42*i+21 - 5, 2, color);  
}
int getJoystickDirection(){
    bool down = JOYSTICK.yAxis() > 0.9;
    bool up = JOYSTICK.yAxis() < -0.9;
    bool left = JOYSTICK.xAxis() > 0.9;
    bool right = JOYSTICK.xAxis() < -0.9;
    // up = 1
    // down = 2
    // left = 3
    // right = 4
    if(up){
        return 1;
    }
    else if(down){
        return 2;
    }
    else if(left){
        return 3;
    }
    else if(right){
        return 4;
    }
    return 0;
}
int getNewTile(int p1jd, int currentTile){
       // up
       if(p1jd==1){
            if(currentTile > 2){
                currentTile -= 3;   
            }   
       }
       // down
       else if(p1jd==2){
            if(currentTile < 6){
                currentTile += 3;   
            }   
       }
       // left
       else if(p1jd==3){
            if(currentTile!=0 && currentTile!=3 && currentTile!=6){
                currentTile -= 1;   
            }   
       }
       // right
       else if(p1jd==4){
           if(currentTile!=2 && currentTile!=5 && currentTile!=8){
               currentTile += 1;
           }
       }
       return currentTile;
}
int checkGameOver(int board[]) {
        // 1 if player 1 won
        // 2 if player 2 won
        // 3 if draw
        int checkSum1 = 0;
        int checkSum2 = 0;
        for(int i = 0; i < 3; i++ ) {
            checkSum1 = board[i] + board[i+3] + board[i+6];
            checkSum2 = board[i*3] + board[i*3+1]+board[i*3+2];
            if(checkSum1 == 3 || checkSum2 == 3) {
                return 1;
            } else if(checkSum1 == 30 || checkSum2 == 30) {
                return 2;
            }
        }
        checkSum1 = board[0]+board[4]+board[8];
        checkSum2 = board[2]+board[4]+board[6];
        if(checkSum1 == 3 || checkSum2 == 3) {
                return 1;
        }
        else if(checkSum1 == 30 || checkSum2 == 30) {
                return 2;
        }
        if(getFirstOpenTile(board) == -1){
            return 3;
        }
        return 0;
}
void handleGameOver(int gameOver){
    if(gameOver == 1){
        // player 1 won
        wait(3);
        uLCD.cls();
        uLCD.printf("You Won!");
        xbee.printf("n,%d,",gameOver);
    }
    else if(gameOver == 2){
        // player 2 won
        wait(3);
        uLCD.cls();
        uLCD.printf("You Lost!");
        xbee.printf("n,%d,",gameOver);
    }
    else if(gameOver == 3){
        // draw
        wait(3);
        uLCD.cls();
        uLCD.printf("Draw!");
        xbee.printf("n,%d,",gameOver);
    }   
}
int read_num(bool num){
    char data[200];
    int count = 0;
    int x = 0;
    while(1){
        data[count] = xbee.getc();
        if(data[count] == ','){
            if(num){
                x = convert_to_int(data,count);
            }
            break;
        }
        else{
            count++;
        }
    }
    return x;
}
int convert_to_int(char data[], int count){
    int current=0;
    for(int i=0; i<count; i++){
        current = current*10;
        current = current + (data[i] - '0');
    }
    return current;
}
void draw_x(int currentTile){
    int j = currentTile/3;
    int i = currentTile%3;
    line(42*i,42*j,42*i+42,42*j+42,GREEN);
    line(42*i+42,42*j,42*i,42*j+42,GREEN);
    
}
void background_color(int color){
    uLCD.background_color(color);
    xbee.printf("a,%d,",color);
    wait_ms(100);
}
void line(int x1,int y1,int x2,int y2,int color) {
    uLCD.line(x1,y1,x2,y2,color);
    xbee.printf("b,%d,%d,%d,%d,%x,",x1,y1,x2,y2,color);
    wait_ms(100);
}
void circle(int x,int y,int radius,int color) { 
    uLCD.circle(x, y, radius, color);
    xbee.printf("c,%d,%d,%d,%x,",x,y,radius,color);
    wait_ms(100);
}
void filled_circle(int x,int y,int radius,int color) { 
    uLCD.filled_circle(x, y, radius, color);
    xbee.printf("d,%d,%d,%d,%x,",x,y,radius,color);
    wait_ms(100);
}
void triangle(int x1,int y1,int x2,int y2,int x3,int y3,int color) {
    uLCD.triangle(x1,y1,x2,y2,x3,y3,color);
    xbee.printf("e,%d,%d,%d,%d,%d,%d,%x,",x1,y1,x2,y2,x3,y3,color);
    wait_ms(100);
}
void rectangle(int x1,int y1,int x2,int y2,int color) {
    uLCD.rectangle(x1,y1,x2,y2,color);
    xbee.printf("f,%d,%d,%d,%d,%x,",x1,y1,x2,y2,color);
    wait_ms(100);
}
void filled_rectangle(int x1,int y1,int x2,int y2,int color) {
    uLCD.filled_rectangle(x1,y1,x2,y2,color);
    xbee.printf("g,%d,%d,%d,%d,%x,",x1,y1,x2,y2,color);
    wait_ms(100);
}
void pixel(int x,int y,int color) { 
    uLCD.pixel(x,y,color);
    xbee.printf("h,%d,%d,%x,",x,y,color);
    wait_ms(100);
}
void cls() { 
    uLCD.cls();
    xbee.printf("i,");
    wait_ms(100);
}
void locate(int x,int y) {
    uLCD.locate(x, y);
    xbee.printf("j,%d,%d,",x,y);
    wait_ms(100);
}
void putc(char a) {
    uLCD.putc(a);
    xbee.printf("k,%c,",a);
    wait_ms(100);
}
void textbackground_color(int color) { 
    uLCD.textbackground_color(color);
    xbee.printf("l,%d,",color);
    wait_ms(100);
}
