#include "mbed.h"
#include "uLCD_4DGL.h"
#include "SparkfunAnalogJoystick.h"

DigitalOut myled(LED1);
Serial pc(USBTX, USBRX);
Serial xbee(p9,p10);
DigitalOut reset(p22);
uLCD_4DGL uLCD(p28,p27,p21); // serial tx, serial rx, reset pin;
SparkfunAnalogJoystick JOYSTICK(p15,p16,p17);
DigitalIn pb(p8);

int getJoystickDirection(void);
void SendUserData(void);
int read_num(bool);
void background_color(void);
void line(void);
void circle(void);
void filled_circle(void);
void triangle(void);
void rectangle(void);
void filled_rectangle(void);
void pixel(void);
void cls(void);
void locate(void);
void putc(void);
void textbackground_color(void);
int convert_to_int(char[],int);
int convert_to_hex(char[],int);

int main() {
    // Reset and set up
    reset=0;
    wait_ms(1);
    reset=1;
    wait_ms(1);
    uLCD.baudrate(3000000);
    uLCD.printf("changed");
    pc.printf("Starting receiver.\r\n");
    myled=0;
        
    // Initial connection
    uLCD.cls();
    uLCD.printf("Connecting with sender...");
    while(!xbee.readable()){}
    uLCD.cls();
    char c = xbee.getc();
    if(c == 'o'){
        uLCD.printf("Connected!");
        xbee.putc('o');
        //clear buffer
        while(xbee.readable()){
            uLCD.printf("Clearing buffer");
            xbee.getc();
        }
    }
    else{
        uLCD.printf("Error");
        wait(5);
    }
    wait(1);
    uLCD.cls();
    
    // variable inits
    char cmd;
    char filler;
    int count=0;
    bool myTurn = false;
    pb.mode(PullUp);
    while(1) {
        count++;
        if(myTurn && count%1000000==0){
            SendUserData();
            count=0;
        }
        if(count>1000000){
            count=0;
        }
        if(xbee.readable()){
            myled=1;
            cmd = xbee.getc();
            filler = xbee.getc();
            switch (cmd){
                case 'a':
                    break;
                case 'b':
                    line();                   
                    break;
                case 'c':
                    circle();
                    break;
                case 'd':
                    filled_circle();
                    break;
                case 'e':
                    triangle();
                    break;
                case 'f':
                    rectangle();
                    break;
                case 'g':
                    filled_rectangle();
                    break;
                case 'h':
                    pixel();
                    break;
                case 'i':
                    cls();
                    break;
                case 'j':
                    locate();
                    break;
                case 'k':
                    putc();
                    break;
                case 'l':
                    textbackground_color();
                    break;
                case 'm':
                    // flip turn
                    myTurn = !myTurn;
                    break;
                case 'n':
                    //game over
                    char z = xbee.getc();
                    int w = z - '0';
                    uLCD.cls();
                    if(w==1){
                        uLCD.printf("You lost!");
                    }
                    else if(w==2){
                        uLCD.printf("You Won!");
                    }
                    else{
                        uLCD.printf("Draw!");
                    }
            }
            myled=0;
        }
    }
}
int getJoystickDirection(){
    bool down = JOYSTICK.yAxis() > 0.6;
    bool up = JOYSTICK.yAxis() < -0.6;
    bool left = JOYSTICK.xAxis() > 0.6;
    bool right = JOYSTICK.xAxis() < -0.6;
    // up = 1
    // down = 2
    // left = 3
    // right = 4
    if(up){
        return 1;
    }
    else if(down){
        return 2;
    }
    else if(left){
        return 3;
    }
    else if(right){
        return 4;
    }
    return 0;
}
void SendUserData(){
    // Joystick Data
    int x = getJoystickDirection();
    // PB
    int pressed = 0;
    if(pb){
        pressed = 0;
    }
    else{
        pressed = 1;
    }
    // Send
    if(x!=0 || pressed==1){
        if(xbee.writeable()){
            xbee.printf("%d,%d,",x,pressed);
            while(!xbee.readable()){}
        }
    }
}
int read_num(bool num){
    char data[200];
    int count = 0;
    int x = 0;
    while(1){
        data[count] = xbee.getc();
        if(data[count] == ','){
            if(num){
                x = convert_to_int(data,count);
            }
            else{
                x = convert_to_hex(data,count);
            }
            break;
        }
        else{
            count++;
        }
    }
    return x;
}
void background_color(){
    int color = read_num(false);
    uLCD.background_color(color);
}
void line() { 
    int x1 = read_num(true);
    int y1 = read_num(true);
    int x2 = read_num(true);
    int y2 = read_num(true);
    int color = read_num(false);
    uLCD.line(x1,y1,x2,y2,color);
}
void circle() { 
    int x = read_num(true);
    int y = read_num(true);
    int radius = read_num(true);
    int color = read_num(false);
    uLCD.circle(x, y, radius, color);
}
void filled_circle() { 
    int x = read_num(true);
    int y = read_num(true);
    int radius = read_num(true);
    int color = read_num(false);
    uLCD.filled_circle(x, y, radius, color);
}
void triangle() { 
    int x1 = read_num(true);
    int y1 = read_num(true);
    int x2 = read_num(true);
    int y2 = read_num(true);
    int x3 = read_num(true);
    int y3 = read_num(true);
    int color = read_num(false);
    uLCD.triangle(x1,y1,x2,y2,x3,y3,color);
}
void rectangle() { 
    int x1 = read_num(true);
    int y1 = read_num(true);
    int x2 = read_num(true);
    int y2 = read_num(true);
    int color = read_num(false);
    uLCD.rectangle(x1,y1,x2,y2,color);
}
void filled_rectangle() { 
    int x1 = read_num(true);
    int y1 = read_num(true);
    int x2 = read_num(true);
    int y2 = read_num(true);
    int color = read_num(false);
    uLCD.filled_rectangle(x1,y1,x2,y2,color);
}
void pixel() { 
    int x = read_num(true);
    int y = read_num(true);
    int color = read_num(false);
    uLCD.pixel(x,y,color);
}
void cls() { 
    uLCD.cls();
}
void locate() { 
    int x = read_num(true);
    int y = read_num(true);
    uLCD.locate(x, y);
}
void putc() { 
    char a = xbee.getc();
    char filler = xbee.getc();
    uLCD.putc(a);
}
void textbackground_color() { 
    int color = read_num(false);
    uLCD.textbackground_color(color);
}
int convert_to_int(char data[], int count){
    int current=0;
    for(int i=0; i<count; i++){
        current = current*10;
        current = current + (data[i] - '0');
    }
    return current;
}
int convert_to_hex(char data[], int count){
    int currentH=0;
    int numH=0;
    for(int i=0; i<count; i++){
        currentH = currentH*16;
        switch(data[i]){
            case 'a':
                numH = 0xa;
                break;
            case 'b':
                numH = 0xb;
                break;
            case 'c':
                numH = 0xc;
                break;
            case 'd':
                numH = 0xd;
                break;
            case 'e':
                numH = 0xe;
                break;
            case 'f':
                numH = 0xf;
                break;
            default:
                numH = data[i]-'0';
                break;
        }
        currentH+=numH;
    }
    return currentH;   
}