#include "mbed.h"
#include "SDFileSystem.h"
#include "wave_player.h"
#include "uLCD_4DGL.h"
//setup some color objects in flash using const's

#include "rtos.h"
#include "Small_6.h"
#include "Small_7.h"
#include "Arial_9.h"
#include "stdio.h"
#include "C12832_lcd.h"

//class for 3 PWM color values for RGBLED
class LEDColor
{
public:
    LEDColor(float r, float g, float b);
    float red;
    float green;
    float blue;
};
LEDColor:: LEDColor(float r, float g, float b)
    : red(r), green(g), blue(b)
{
}
//Operator overload to adjust brightness with no color change
LEDColor operator * (const LEDColor& x, const float& b)
{
    return LEDColor(x.red*b,x.green*b,x.blue*b);
}
//Operator overload to add colors
LEDColor operator + (const LEDColor& x, const LEDColor& y)
{
    return LEDColor(x.red+y.red,x.green+y.green,x.blue+y.blue);
}
 
//Class to control an RGB LED using three PWM pins
class RGBLed
{
public:
    RGBLed(PinName redpin, PinName greenpin, PinName bluepin);
    void write(float red,float green, float blue);
    void write(LEDColor c);
    RGBLed operator = (LEDColor c) {
        write(c);
        return *this;
    };
private:
    PwmOut _redpin;
    PwmOut _greenpin;
    PwmOut _bluepin;
};
 
RGBLed::RGBLed (PinName redpin, PinName greenpin, PinName bluepin)
    : _redpin(redpin), _greenpin(greenpin), _bluepin(bluepin)
{
    //50Hz PWM clock default a bit too low, go to 2000Hz (less flicker)
    _redpin.period(0.0005);
}
 
void RGBLed::write(float red,float green, float blue)
{
    _redpin = red;
    _greenpin = green;
    _bluepin = blue;
}
void RGBLed::write(LEDColor c)
{
    _redpin = c.red;
    _greenpin = c.green;
    _bluepin = c.blue;
}
 
//classes could be moved to include file
 
//Setup RGB led using PWM pins and class
RGBLed myRGBled(p23,p22,p21); //RGB PWM pins
const LEDColor red(1.0,0.0,0.0);
const LEDColor green(0.0,0.2,0.0);
//brighter green LED is scaled down to same as red and
//blue LED outputs on Sparkfun RGBLED
const LEDColor blue(0.0,0.0,1.0);
const LEDColor yellow(1.0,0.2,0.0);
const LEDColor white(1.0,0.2,1.0);
const LEDColor black(0.0,0.0,0.0);
char bred=0;
char bgreen=0;
char bblue=0; 

volatile bool songselect = false;
volatile bool homescreen = true;
uLCD_4DGL uLCD(p28,p27,p30); 
SDFileSystem sd(p5, p6, p7, p8, "sd"); //SD card
DigitalOut myled(LED1);
DigitalIn pb1(p20);
DigitalIn pb2(p19);
AnalogOut DACout(p18);
wave_player waver(&DACout);

// mutex to make the lcd lib thread safe
Mutex lcd_mutex;
int songnum = 1;
AnalogIn joy_pot(p16);
// Thread 1
// print homescreen to LCD
void thread1(void const *args)
{
    
    while(true) {       // thread loop
        
        if (homescreen){
            lcd_mutex.lock();
            uLCD.cls();
            uLCD.text_height(1.9);
            uLCD.text_width(1.9);
            uLCD.color(WHITE);
            uLCD.locate(0,0);
            uLCD.printf("Pick a song");
            uLCD.text_height(1.9);
            uLCD.text_width(1.9);
            uLCD.locate(1,2);
            uLCD.printf("Song1");
            uLCD.locate(1,4);
            uLCD.printf("Song2");
            uLCD.locate(1,6);
            uLCD.printf("Song3");
            uLCD.locate(1,8);
            uLCD.printf("Song4");
            uLCD.rectangle(5, songnum*16-2, 100, songnum*16+8 ,GREEN);
            lcd_mutex.unlock();
            
                }
            Thread::wait(200);    
    }
}

//for song selection during homescreen
void thread2(void const *args)
{

   while(1){
        if (homescreen){
            if ((joy_pot <= (1.4/3.3)) && songnum>1) {
                songnum--;
                } 
            else if ((joy_pot >= (1.8/3.3)) && songnum<4){
                songnum++;
                }
            }
        Thread::wait(250);
        
    }
}

// Thread 3
//pb1 is to select song
//pb2 is to return to homescreen
void thread3(void const *args)
{
    pb1.mode(PullUp);
    pb2.mode(PullUp);
    while(true) {       // thread loop
        if (!pb2)
            {
            homescreen = true;
            songselect = false;
            }
        if (!pb1)
            {
            songselect = true;
            }
        Thread::wait(100);   // value of pot1 / 100
    }
}

int main()
{
    //doesnt work yet, need to ask hamblen

    uLCD.media_init();
    uLCD.set_sector_address(0x001D, 0x4C01);
    uLCD.display_image(0,0);
//    t1.start(thread1);
//   t2.start(thread2);
//    t3.start(thread3);
    Thread t1(thread1);
    Thread t2(thread2);
    Thread t3(thread3);
    //startup sound. Commented out for testing without SD card
    //FILE *wave_file;
    //wave_file=fopen("/sd/cheer.wav","r");
    //waver.play(wave_file);
    //fclose(wave_file);
    while(1) 
    {
        
        if (songselect){
                myled = 0;
                homescreen = false;
                lcd_mutex.lock();
                uLCD.cls();
                uLCD.printf("You selected song %2d",songnum);
                lcd_mutex.unlock();
                //add case statement based on songnum or something
                //code for playing song from sd
                //FILE *wave_file;
                //wave_file=fopen("/sd/sample1.wav","r");
                //waver.play(wave_file);
                //fclose(wave_file);
                //end
                }
        Thread::wait(100);    
        }
}
        

