#include "Lane.hpp"
#include "globals.h"
Lane::Lane(int x, int y) {
    xpos = x;
    ypos = y;
    empty = false;
}

void Lane::add() {
    ++bubblesDrawn;
    pops.push_back(Bubble(xpos, ypos));
}

void Lane::draw() {
    if (!pops.empty()){
        for (pops_ptr = pops.begin(); pops_ptr < pops.end(); pops_ptr++) {
            (*pops_ptr).draw();
        }
    }
}

void Lane::moveDown() {
    // move each bubble
    //if they're past a certain horizontal limit, remove them from the dynamic array
    if ((pops.begin())->getYpos() >= 110+20) {
        // black out the bubble and remove it from the lane's vector
        (pops.begin())->clear();
        pops.erase(pops.begin());
        ++bubblesMissed;
    }
    
    for (pops_ptr = pops.begin(); pops_ptr < pops.end(); pops_ptr++) {
        (*pops_ptr).moveDown();
    }
}

bool Lane::isEmpty() {
    return pops.empty();
}

bool Lane::checkHit() {
    if ((pops.begin())->getYpos() <= 110+20 && (pops.begin())->getYpos() >= 110-20) {
        // black out the bubble and remove it from the lane's vector
        (pops.begin())->clear();
        pops.erase(pops.begin());
        return true;
    }
    return false;
}