#include "mbed.h"
#define rpdd_debug_printf(...) printf(__VA_ARGS__);
class RPDD
{
public:
    int random_photo_data_downlink(uint8_t* uart_data);
    void first_tlm_sending(uint8_t camera_num,uint8_t save_data_id);
    void photo_data_sending_gmsk(uint8_t camera_num,uint8_t save_data_id,uint8_t readout_block_num);
    void photo_data_sending_afsk(uint8_t camera_num,uint8_t save_data_id,uint8_t readout_block_num);
    RPDD();

private:
    uint8_t camera_num1;
    //画像ダウンリンクデータ１カメラ選択
    uint8_t camera_num2;
    //画像ダウンリンクデータ２カメラ選択
    uint8_t camera_num3;
    //画像ダウンリンクデータ３カメラ選択
    uint8_t downlink_cnt;
    //コマンドによって指定されるダウンリンクの回数
    int practical_dl_cnt;
    //実際にダウンリンクした回数
    uint8_t loop_cnt;
    //ループ回数
    uint8_t com_style;
    //通信方式
    uint8_t save_data_id1;
    uint8_t save_data_id2;
    uint8_t save_data_id3;
    //画像保存データID
    uint8_t readout_block_num1;
    uint8_t readout_block_num2;
    uint8_t readout_block_num3;
    //読み出しブロック番号123
    int readout_byte;
    //これまでに読み出したバイト数
    int process_stage;
    /*プログラム内で処理内容を分けるために用いる変数
     _________________________________________________________________________________________
    | process stage |____________________________________処理内容______________________________|
    |_______________|__________☆AFSKモード☆_________________|_____☆GMSK及び高速通信モード☆_____|
    |_______1_______|_______1枚目の画像情報を送信______________|______1枚目の画像情報と画像の送信____|
    |_______2_______|_______1枚目の画像１ブロック分全て送信______|______2枚目の画像情報と画像の送信____|
    |_______3_______|_______2枚目の画像情報送信________________|______3枚目の画像情報と画像の送信____|
    |_______4_______|_______2枚目の画像１ブロック分全て送信______|
    |_______5_______|_______3枚目の画像情報送信________________|
    |_______6_______|_______3枚目の画像１ブロック分全て送信______|
    */
};