#include "mbed.h"
#include "rpdd_ver2.h"
#include "fm_dd.h"
#include "missionDR.h"

Fm transmitter;
MissionDR dr;

RPDD::RPDD()
{
    camera_num1=1;
    camera_num2=1;
    camera_num3=1;
    downlink_cnt=1;
    practical_dl_cnt=0;
    com_style=0;
    save_data_id1=1;
    save_data_id2=1;
    save_data_id3=1;
    readout_block_num1=1;
    readout_block_num2=1;
    readout_block_num3=1;
    loop_cnt = 1;
    readout_byte = 0;
    process_stage = 1;
}
void RPDD::first_tlm_sending(uint8_t camera_num,uint8_t save_data_id)
{
    int block_num = 0;
    uint8_t first_telemetly[7]= {0},photo_info[512]= {0};
    block_num = 1 + (save_data_id-1)*321;
    dr.read(photo_info,block_num,1);
    first_telemetly[0]=4;
    first_telemetly[1]=camera_num;
    first_telemetly[2]=save_data_id;
    for(int i=0; i<4; i++) {
        first_telemetly[i+3]=photo_info[i];
    }
    transmitter.send(first_telemetly,7);
    loop_cnt++;
    process_stage++;
}
void RPDD::photo_data_sending_afsk(uint8_t camera_num,uint8_t save_data_id,uint8_t readout_block_num)
{
    int block_num=0;
    uint8_t photo_data[512]= {0},packet[128]= {0};
    block_num = 1 + (save_data_id-1)*321 + (camera_num-1)*80 + readout_block_num;
    dr.read(photo_data,block_num,1);
    if(readout_byte == 512) {
        process_stage++;
        readout_byte =0;//読み出したバイト数が512ということは１ブロック分送信が終了しているのでリセット
    } else if(readout_byte<=512) {
        for(int i=0; i<128; i++) {
            packet[i]=photo_data[readout_byte];
            readout_byte++;
        }
    } else {
    }
    readout_byte = readout_byte + 128;
    transmitter.send(packet,128);
    loop_cnt++;
    if(loop_cnt == 16) {
        process_stage=1;
        practical_dl_cnt++;
        loop_cnt=0;
    } else {}
}
void RPDD::photo_data_sending_gmsk(uint8_t camera_num,uint8_t save_data_id,uint8_t readout_block_num)
{
    int block_num=0;
    uint8_t photo_data[512]= {0},packet1[128]= {0},packet2[128]= {0};
    block_num = 1 + (save_data_id-1)*321 + (camera_num-1)*80 + readout_block_num;
    dr.read(photo_data,block_num,1);
    for(int i=0; i<256; i++) {
        packet1[i]=photo_data[i];
        packet2[i]=photo_data[i+256];
    }
    transmitter.send(packet1,256);
    transmitter.send(packet2,256);
    loop_cnt = loop_cnt+2;
    if(loop_cnt == 10) {
        practical_dl_cnt++;
        loop_cnt = 0;
    } else {}
}

int RPDD::random_photo_data_downlink(uint8_t* uart_data)
{
    int flag_RPDD = 0;
    camera_num1 = uart_data[3]>>6;
    camera_num2 = uart_data[3]<<2;
    camera_num2 = camera_num2>>6;
    camera_num3 = uart_data[3]<<4;
    camera_num3 = camera_num3>>6;
    downlink_cnt = uart_data[3]<<6;
    downlink_cnt = downlink_cnt>>6;
    com_style = uart_data[4]>>5;
    save_data_id1 = uart_data[4]<<4;
    save_data_id1 = save_data_id1>>4;
    save_data_id2 = uart_data[5]>>4;
    save_data_id3 = uart_data[5]<<4;
    save_data_id3 = save_data_id3>>4;
    readout_block_num1 = uart_data[6];
    readout_block_num2 = uart_data[7];
    readout_block_num3 = uart_data[8];
    if(com_style==0) {
        switch(process_stage) {
            case 1:
                first_tlm_sending(camera_num1,save_data_id1);
                break;
            case 2:
                photo_data_sending_afsk(camera_num1,save_data_id1,readout_block_num1);
                break;
            case 3:
                first_tlm_sending(camera_num2,save_data_id2);
                break;
            case 4:
                photo_data_sending_afsk(camera_num2,save_data_id2,readout_block_num2);
                break;
            case 5:
                first_tlm_sending(camera_num3,save_data_id3);
                break;
            case 6:
                photo_data_sending_afsk(camera_num3,save_data_id3,readout_block_num3);
                break;
            default:
                return 0;
        }
    } else {
        switch(process_stage) {
            case 1:
                first_tlm_sending(camera_num1,save_data_id1);
                photo_data_sending_gmsk(camera_num1,save_data_id1,readout_block_num1);
                break;
            case 2:
                first_tlm_sending(camera_num2,save_data_id2);
                photo_data_sending_gmsk(camera_num2,save_data_id2,readout_block_num2);
                break;
            case 3:
                first_tlm_sending(camera_num3,save_data_id3);
                photo_data_sending_gmsk(camera_num3,save_data_id3,readout_block_num3);
            default:
                return 0;
        }
    }
    if(practical_dl_cnt==downlink_cnt) {
        flag_RPDD = 1;
    } else {
        flag_RPDD = 0;
    }
    return flag_RPDD;
}