#include "type_define.h"
#include "mbed.h"

#define DEBUG
#ifdef DEBUG
#define bpdd_debug_printf(...) printf(__VA_ARGS__)
#else
#define bpdd_debug_printf(...) (void)0
#endif

class BPDD
{
    public:
    bool bundle_photo_data_downlink(u8* uart_data);
    void photo_info_sending(void);
    void photo_data_AFSK_sending(void);
    void photo_data_GFSK_sending(void);
    
    BPDD();
    
    private:
    bool flag_BPDD;
    //フラグ,この処理の中で１度送信を行っているか判断するためのフラグ,block数,SDが異常かのフラグ
    bool permit[4];
    //カメラ許可/不許可
    uint8_t camera_id;
    //ダウンリンクするカメラ番号(0~3)
    uint8_t downlink_num;
    //コマンドで指定された送信回数
    uint8_t downlink_cnt;
    //実際の送信回数
    uint8_t com_style;
    //通信方式
    uint8_t save_data_id;
    //画像保存データID(0~9)
    int readout_block_num;
    //読み出しが完了したブロック数
    int send_cnt;
    //パケット
    int num_repeat;
    //画像データを何回送信したか
    int total_cnt;
    //1コマンドで行う全てのループ回数
    uint8_t size;
    //目的の画像の容量
    int block_num;
};