#include "mbed.h"
#include "type_define.h"
#include "bundle_photo_data_downlink.h"
#include "fm_dd.h"
#include "missionDR.h"

#pragma diag_suppress 870

Timer BPDDtimer;

Fm transmitter;
MissionDR dr;

BPDD::BPDD()//コンストラクタ
{
    flag_BPDD=0;
    permit[0]=0;
    permit[1]=0;
    permit[2]=0;
    permit[3]=0;
    camera_id=0;
    downlink_num=1;//最低1回は送信するので
    downlink_cnt=0;
    com_style=0;
    save_data_id=1;
    readout_block_num=0;
    send_cnt=0;
    num_repeat=0;
    total_cnt=0;
    size=1;//デバッグ
    block_num=0;

}

void BPDD::photo_info_sending(void)
{
    uint8_t photo_info[512]= {0};
    uint8_t first_telemetry[128]= {0};

    bpdd_debug_printf("photo info readout process\r\n");
    bpdd_debug_printf("save_data_id(in photo info sending func):%d\r\n",save_data_id);
    block_num = 1 + save_data_id*321;
    bpdd_debug_printf("block num for photo info:%d\r\n",block_num);
    //dr.read(photo_info,block_num,1);
    bpdd_debug_printf("photo info reading...\r\n");

    size = photo_info[4+camera_id];//DRマップ参照のこと
    size=2;//SDに0しか書かれていなくて困るので、今だけ

    //bpdd_debug_printf("画像サイズ(ブロック):%d\r\n",size);

    first_telemetry[0] = 3;//テレメトリID
    first_telemetry[1] = camera_id+1;//カメラ番号(1~4)
    first_telemetry[2] = save_data_id+1;//画像保存データID(1~10)
    for(int i=3; i<34; i++) {
        first_telemetry[i]=photo_info[i-3];//RTC時刻(4byte)画像容量(4byte),姿勢データ(24byte)を保存
    }
    bpdd_debug_printf("first telemetly has formed\r\n");

    /*printf("first telemetry of photo data\r\n");
    for(int i=0;i<128;i++){
     printf("%d,",first_telemetry[i]);
     }*/

    transmitter.baud(com_style);
    //transmitter.send(first_telemetry,128);
    printf("first telemetly sended\r\n");
    block_num=block_num+1+80*camera_id;//画像データ保存先へ移動
    printf("block_num:%d\r\n",block_num);
    num_repeat++;
    //printf("photo info processing time:%d\r\n",BPDDtimer.read_ms());
}

void BPDD::photo_data_AFSK_sending(void)
{
    bpdd_debug_printf("send_cnt:%d\r\n",send_cnt);
    uint8_t photo_data_AFSK[512]= {0};
    uint8_t photo_packet_afsk[128]= {0};
    printf("block_num : %d\r\n",block_num);
    if(send_cnt<=4) {
        if(send_cnt==0) {
            //dr.read(photo_data_AFSK,block_num,1);
            bpdd_debug_printf("photo data reading...\r\n");
        }
        /*printf("photo data\r\n");
        for(int i=0;i<512;i++){
            printf("%d,",photo_data[i]);
        }*/
        for(int i=0; i<128; i++) {
            photo_packet_afsk[i]=photo_data_AFSK[i+128*send_cnt];
        }
        //transmitter.baud(com_style);
        //transmitter.send(photo_packet_afsk,128);
        bpdd_debug_printf("photo data sending...\r\n");
        send_cnt++;
        //printf("%dブロック目、%dパケット目送信完了\r\n",block_num,send_cnt);
        num_repeat++;
        //printf("AFSK photo data send processing time:%d\r\n",BPDDtimer.read_ms());
        if(send_cnt>=4) {
            printf("%dblock sended\r\n",block_num);
            send_cnt=0;
            readout_block_num++;
            block_num++;
            //printf("block number send processing time:%d\r\n",BPDDtimer.read_ms());

            //bpdd_debug_printf("readout_block_num:%d\r\n",readout_block_num);
            //printf("num_repeat:%d\r\n",num_repeat);
        }
    }
}

void BPDD::photo_data_GFSK_sending(void)
{
    bpdd_debug_printf("GMSK or rapid communication process\r\n");

    uint8_t photo_data_GFSK[512]= {0};
    uint8_t photo_packet1[256]= {0};
    uint8_t photo_packet2[256]= {0};
    ///dr.read(photo_data_GFSK,block_num,1);
    for(int i = 0; i<256; i++) {
        photo_packet1[i] = photo_data_GFSK[i];
        photo_packet2[i] = photo_data_GFSK[i+256];
    }
    transmitter.baud(com_style);
    transmitter.send(photo_packet1,256);
    transmitter.send(photo_packet2,256);

    printf("%d sending complete\r\n",block_num);
    num_repeat++;
    readout_block_num++;
    block_num++;
    //printf("GFSK photo data send processing time:%d\r\n",BPDDtimer.read_ms());
}


bool BPDD::bundle_photo_data_downlink(u8* uart_data)
{
    BPDDtimer.reset();
    BPDDtimer.start();

    //printf("%dループ目\r\n",num_repeat+1);

    if(total_cnt==0) {
        uint8_t p=0;
        for(int i=0; i<4; i++) {
            p=uart_data[6]<<(7-i);
            permit[i]=p>>7;
        }

        save_data_id = uart_data[3];
        com_style = uart_data[4]<<5;
        com_style = com_style>>5;
        downlink_num = uart_data[4]>>6;

        printf("%d,%d,%d,%d\r\n",permit[0],permit[1],permit[2],permit[3]);//test
        printf("save_data_ID：%d\r\n",save_data_id);//test
        printf("com_style%d\r\n",com_style);//test
        printf("downlink_num：%d\r\n",downlink_num);//test
    }

    total_cnt++;

    for(int i=0; i<4; i++) {
        if(permit[3-i]==1) {
            camera_id=3-i;
        }
    }
    bpdd_debug_printf("camera_id is %d\r\n",camera_id);
    //printf("カメラID:%d\r\n",camera_id);//test
    bpdd_debug_printf("num_repeat is %d\r\n",num_repeat);
    if(num_repeat == 0) {
        bpdd_debug_printf("photo info sending process\r\n");
        photo_info_sending();
    } else {
        bpdd_debug_printf("photo data sending process\r\n");
        printf("downlink_cnt :%d,downlink_num :%d\r\n",downlink_cnt,downlink_num);
        printf("com_style is %d\r\n",com_style);
        if(downlink_cnt<downlink_num) { //分割データ送信回数回データを送る
            if(com_style == 0) {
                printf("AFSK sending process\r\n");
                photo_data_AFSK_sending();
            } else {
                photo_data_GFSK_sending();
            }
        }else{
            printf("downlink count is not inputed\r\n");
            return 1;//ダウンリンクする回数が指定されていなかったとき用の例外処理
            }
    }

    if(readout_block_num == size) { //読み出したブロックの数と画像のブロックサイズが一致している
        downlink_cnt++;
        readout_block_num=0;
        //if(num_repeat-1==downlink_num*4*readout_block_num||downlink_num*readout_block_num == num_repeat-1) { //画像を実際送信した回数と指定した送信回数が一致している（cnt実装前）}
        if(downlink_cnt>=downlink_num) {
            permit[camera_id]=0;
            downlink_cnt=0;
            num_repeat=0;
            if((permit[0]|permit[1]|permit[2]|permit[3])==0) {
                printf("permit=%d\r\n",permit[0]|permit[1]|permit[2]|permit[3]);
                total_cnt=0;
                printf("mission complete!\r\n");
                flag_BPDD = 1;
            } else {
                flag_BPDD = 0;
            }
        } else {
            flag_BPDD = 0;
        }
    } else {
        flag_BPDD = 0;
    }

    return flag_BPDD;
}