#include "mbed.h"
#include "ADXL362.h"
 
// Interface pulled from ADXL362.cpp
// ADXL362::ADXL362(PinName CS, PinName MOSI, PinName MISO, PinName SCK) :
ADXL362 adxl362(PA_0,PA_7,PA_6,PA_1);
DigitalOut led1(LED1);

 
int adxl362_reg_print(int start, int length) {
    if(length == 0)
        length = 46;
    int i = start, end = start + length;     
    if(start > 0x2E || start < 0x00)
        return(-1);
    if(length < 0)
        return(-1);
    if (adxl362.read_reg((ADXL362::ADXL362_register_t) 0x00) != 0xAD)
        return(-1);
    if (end > 47)
        return(-1);
    for( i = start; i <= end; i++) {
        //0x16 -> 0x1E not used
        //0x04 -> 0x07 not used
        if (i == 0x04) i = 0x08; 
        if (i == 0x16) i = 0x1F;
        char name[25];
        uint8_t regval = adxl362.read_reg((ADXL362::ADXL362_register_t) i);
         switch (i) { 
            case 0x00:
                strcpy(name,"DEVID_A");
                break;
            case 0x01:
                strcpy(name,"DEVID_MST");
                break;
            case 0x02:
                strcpy(name, "PARTID");
                break;
            case 0x03:
                strcpy(name,"REVID");
                break;
            case 0x08:
                strcpy(name,"XDATA");
                break;
            case 0x09:
                strcpy(name,"YDATA");
                break;
            case 0x0A:
                strcpy(name,"ZDATA");
                break;
            case 0x0B:
                strcpy(name,"STATUS");
                break;
            case 0x0C:
                strcpy(name,"FIFO_ENTRIES_L");
                break;
            case 0x0D:
                strcpy(name,"FIFO_ENTRIES_H");
                break;
            case 0x0E:
                strcpy(name,"XDATA_L");
                break;
            case 0x0F:
                strcpy(name,"XDATA_H");
                break;
            case 0x10:
                strcpy(name,"YDATA_L");
                break;
            case 0x11:
                strcpy(name,"YDATA_H");
                break;
            case 0x12:
                strcpy(name,"ZDATA_L");
                break;
            case 0x13:
                strcpy(name,"ZDATA_H");
                break;
            case 0x14:
                strcpy(name,"TEMP_L");
                break;
            case 0x15:
                strcpy(name,"TEMP_H");
                break;
            case 0x1F:
                strcpy(name,"SOFT_RESET");
                break;
            case 0x20:
                strcpy(name,"THRESH_ACT_L");
                break;
            case 0x21:
                strcpy(name,"THRESH_ACT_H");
                break;
            case 0x22:
                strcpy(name,"TIME_ACT");
                break;
            case 0x23:
                strcpy(name,"THRES_INACT_L");
                break;
            case 0x24:
                strcpy(name,"THRESH_INACT_H");
                break;
            case 0x25:
                strcpy(name,"TIME_INACT_L");
                break;
            case 0x26:
                strcpy(name,"TIME_INACT_H");
                break;
            case 0x27:
                strcpy(name,"ACT_INACT_CTL");
                break;
            case 0x28:
                strcpy(name,"FIFO_CONTROL");
                break;
            case 0x29:
                strcpy(name,"FIFO_SAMPLES");
                break;
            case 0x2A:
                strcpy(name,"INTMAP1");
                break;
            case 0x2B:
                strcpy(name,"INTMAP2");
                break;
            case 0x2C:
                strcpy(name,"FILTER_CTL");
            break;
            case 0x2D:
                strcpy(name,"POWER_CTL");
                break;
            case 0x2E:
                strcpy(name,"SELF_TEST");
                break;
            default:
                printf("ERR\n\r");
        } 
        printf("0x%02X: %s = 0x%02X\n\r", i, name, regval); 
        
    }
    return(0);
} 



int main() {
    adxl362.reset();
    wait_ms(600); // we need to wait at least 500ms after ADXL362 reset
    adxl362.set_mode(ADXL362::MEASUREMENT);
    int return_val, start, length;
    int8_t x,y,z,a,b,c, t=4;
    printf("Enter start: \n\r");
    scanf("%d", &start);
    printf("Enter length: \n\r");
    scanf("%d", &length);
    return_val = adxl362_reg_print(start, length);
    printf("Return Val Read Reg: %d \n\r", return_val);
    wait_ms(5000);
    while(1) {
        x=adxl362.scanx_u8();
        y=adxl362.scany_u8();
        z=adxl362.scanz_u8();
        wait_ms(10);
        a=adxl362.scanx_u8();
        b=adxl362.scany_u8();
        c=adxl362.scanz_u8();
        if (a >= x+t || a <= x-t ||
            b >= y+t || b <= y-t ||
            c >= z+t || c <= z-t) {
            printf("Knock\n\r");
            led1 = 1;
            wait_ms(2000);
            led1 = 0;
            
        } 
        
    }
}
