/**
 ******************************************************************************
 * @file    main.cpp
 * @author  AST / EST
 * @version V0.0.1
 * @date    14-August-2015
 * @brief   Simple Example application for using the X_NUCLEO_IKS01A1 
 *          MEMS Inertial & Environmental Sensor Nucleo expansion board.
 ******************************************************************************
 * @attention
 *
 * <h2><center>&copy; COPYRIGHT(c) 2015 STMicroelectronics</center></h2>
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *   1. Redistributions of source code must retain the above copyright notice,
 *      this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright notice,
 *      this list of conditions and the following disclaimer in the documentation
 *      and/or other materials provided with the distribution.
 *   3. Neither the name of STMicroelectronics nor the names of its contributors
 *      may be used to endorse or promote products derived from this software
 *      without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 *  SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ******************************************************************************
*/ 

/* Includes */
#include "main.h"

/* Instantiate the expansion board */
static X_NUCLEO_IKS01A1 *mems_expansion_board = X_NUCLEO_IKS01A1::Instance(D14, D15);

/* Retrieve the composing elements of the expansion board */
static GyroSensor *gyroscope = mems_expansion_board->GetGyroscope();
static MotionSensor *accelerometer = mems_expansion_board->GetAccelerometer();
static MagneticSensor *magnetometer = mems_expansion_board->magnetometer;
static HumiditySensor *humidity_sensor = mems_expansion_board->ht_sensor;
static PressureSensor *pressure_sensor = mems_expansion_board->pt_sensor;
static TempSensor *temp_sensor1 = mems_expansion_board->ht_sensor;
static TempSensor *temp_sensor2 = mems_expansion_board->pt_sensor;

/* Helper function for printing floats & doubles */
static char *printDouble(char* str, double v, int decimalDigits=2)
{
  int i = 1;
  int intPart, fractPart;
  int len;
  char *ptr;

  /* prepare decimal digits multiplicator */
  for (;decimalDigits!=0; i*=10, decimalDigits--);

  /* calculate integer & fractinal parts */
  intPart = (int)v;
  fractPart = (int)((v-(double)(int)v)*i);

  /* fill in integer part */
  sprintf(str, "%i.", intPart);

  /* prepare fill in of fractional part */
  len = strlen(str);
  ptr = &str[len];

  /* fill in leading fractional zeros */
  for (i/=10;i>1; i/=10, ptr++) {
    if(fractPart >= i) break;
    *ptr = '0';
  }

  /* fill in (rest of) fractional part */
  sprintf(ptr, "%i", fractPart);

  return str;
}

DigitalOut myled(LED1);
DigitalIn mybutton(USER_BUTTON);
Display mydisplay;
RawData myrawdata;

uint8_t fbtn=BTN_RELEASED;
uint8_t fbtn_counter=0;
uint8_t mode=MODE_NORMAL;
uint8_t func=FUNC_DATETIME;
uint8_t config_index=0;
uint8_t flag_flash=0;


/**
 * FUNC: wait_action
 * DESC: wait for pressing button action, update the global flag for next polling cycle
 */
void wait_action()
{
    fbtn=BTN_RELEASED;
    for(int i=0; i<5; i++)
    {
        if(fbtn==BTN_RELEASED)
        {
            if(mybutton==1 and fbtn==BTN_RELEASED)
            {
                if(fbtn_counter>0 and fbtn_counter<=20)
                {
                    fbtn=BTN_PRESSED;
                }
                else if(fbtn_counter>20 and fbtn_counter<=50)
                {
                    fbtn=BTN_PRESSED_LONG;
                }
                else if(fbtn_counter>50)
                {
                    fbtn=BTN_PRESSED_VERY_LONG;
                }
                fbtn_counter=0;
            }
            else
            {
                fbtn_counter+=1;
            }
        }
        wait(0.1);
    }
}


/* Simple main function */
int main() {
  myled=0;
  uint8_t func=0;
  uint8_t button_mem=0;
  

  
  uint8_t id;
  float value1, value2;
  char buffer0[16];
  char buffer1[32], buffer2[32];
  int32_t axes[3];
  int16_t axxx[3];
  
 /* 
  
  PersistorStorage ps=PersistorStorage();
  strcpy(ps.storage, "hello");
  ps.writeStorageToFlash();
  
  PersistorStorage ps1=PersistorStorage();
  ps1.ReadStorageFromFlash();

  printf("%s", ps1.storage);
*/
/*HAL_Init();
__HAL_FLASH_CLEAR_FLAG( FLASH_FLAG_EOP | FLASH_FLAG_OPERR |FLASH_FLAG_WRPERR | FLASH_FLAG_PGAERR | FLASH_FLAG_PGSERR );
printf("hello\n");
uint64_t a=124;
uint32_t pageerr = 100;
HAL_FLASH_Unlock();
FLASH_EraseInitTypeDef es;
es.TypeErase=FLASH_TYPEERASE_MASSERASE;
es.Banks=FLASH_BANK_2;
es.Page=0;
es.NbPages=1;

if( HAL_OK != (HAL_FLASHEx_Erase_IT( &es))) {
        printf("ERROR %d\n", pageerr);
        HAL_FLASH_Lock();
}
__HAL_FLASH_CLEAR_FLAG( FLASH_FLAG_EOP | FLASH_FLAG_OPERR |FLASH_FLAG_WRPERR | FLASH_FLAG_PGAERR | FLASH_FLAG_PGSERR );
HAL_FLASH_Unlock();
printf("%d\n", HAL_FLASH_Program(FLASH_TYPEPROGRAM_DOUBLEWORD, 0x08080000, a));
printf("hello\n");
printf("%d\n", HAL_FLASH_GetError());
HAL_FLASH_Lock();

static const int StorageSize = 64;
static unsigned int storage[ StorageSize ] __attribute__((aligned(32)));
HAL_FLASH_Unlock();
memcpy( (uint32_t*)storage, (uint32_t*)(0x08080000), StorageSize);
HAL_FLASH_Lock();

for(int i=0; i<StorageSize; i++)
{
    printf("%4x ",storage[i]);
}
printf("\n");
*/
  
/*  
  printf("\r\n--- Starting new run ---\r\n");

  humidity_sensor->ReadID(&id);
  printf("HTS221  humidity & temperature    = 0x%X\r\n", id);
  pressure_sensor->ReadID(&id);
  printf("LPS25H  pressure & temperature    = 0x%X\r\n", id);
  magnetometer->ReadID(&id);
  printf("LIS3MDL magnetometer              = 0x%X\r\n", id);
  gyroscope->ReadID(&id);
  printf("LSM6DS0 accelerometer & gyroscope = 0x%X\r\n", id);
*/
float pressure=0;
while(1)
{
    // MEASURE AND DISPLAY
    if(mode==MODE_NORMAL)
    {
        myled=0;
        if(func==FUNC_DATETIME)
        {
            myrawdata.__time=time(NULL);
            myrawdata.str_date(buffer0);
            myrawdata.str_time(buffer1);
        }
        else if(func==FUNC_TEMPHUMI)
        {
            temp_sensor1->GetTemperature(&myrawdata.__temp);
            humidity_sensor->GetHumidity(&myrawdata.__humi);
            myrawdata.str_temperature(buffer0);
            myrawdata.str_humidity(buffer1);
        }
        else if(func==FUNC_ALTICDIR)
        {
            pressure_sensor->GetPressure(&pressure);
            myrawdata.__prss = pressure * 10;
            magnetometer->Get_M_Axes(myrawdata.__mag);
            accelerometer->Get_X_Axes(myrawdata.__acc);
            gyroscope->Get_G_Axes(myrawdata.__gyr);
            myrawdata.str_altitude(buffer0);
            myrawdata.str_direction(buffer1);
        }
        mydisplay.show(buffer0, buffer1);
    }
    else if(mode==MODE_CONFIG)
    {
        myled=1;
        if(func==FUNC_DATETIME)
        {
            myrawdata.str_date(buffer0);
            myrawdata.str_time(buffer1);
            if(flag_flash)
            {
                if(config_index==0)
                {
                    buffer0[0]=0xff;
                }
                else if(config_index==1)
                {
                    buffer0[1]=0xff;
                }
                else if(config_index==2)
                {
                    buffer0[3]=0xff;
                    buffer0[4]=0xff;
                }
                else if(config_index==3)
                {
                    buffer0[6]=0xff;
                    buffer0[7]=0xff;
                }
                else if(config_index==4)
                {
                    buffer1[0]=0xff;
                    buffer1[1]=0xff;
                }
                else if(config_index==5)
                {
                    buffer1[3]=0xff;
                }
                else if(config_index==6)
                {
                    buffer1[4]=0xff;
                }
                else if(config_index==7)
                {
                    buffer1[6]=0xff;
                }
                else if(config_index==8)
                {
                    buffer1[7]=0xff;
                }
            }
        }
        if(func==FUNC_TEMPHUMI)
        {
            myrawdata.str_temperature(buffer0);
            myrawdata.str_humidity(buffer1);
            if(flag_flash)
            {
                if(config_index==0)
                {
                    buffer0[2]=0xff;
                }
                else if(config_index==1)
                {
                    buffer0[3]=0xff;
                }
                else if(config_index==2)
                {
                    buffer0[4]=0xff;
                }
                else if(config_index==3)
                {
                    buffer0[6]=0xff;
                }
                else if(config_index==4)
                {
                    buffer1[3]=0xff;
                }
                else if(config_index==5)
                {
                    buffer1[4]=0xff;
                }
                else if(config_index==6)
                {
                    buffer1[6]=0xff;
                }
            }
        }
        else if(func==FUNC_ALTICDIR)
        {
            myrawdata.str_altitude(buffer0);
            myrawdata.str_direction(buffer1);
            if(flag_flash)
            {
                if(config_index==0)
                {
                    buffer0[3]=0xff;
                }
                else if(config_index==1)
                {
                    buffer0[4]=0xff;
                }
                else if(config_index==2)
                {
                    buffer0[5]=0xff;
                }
                else if(config_index==3)
                {
                    buffer0[6]=0xff;
                }
            }
        }
        
        if(flag_flash)
        {
            flag_flash=0;
        }
        else
        {
            flag_flash=1;
        }
        mydisplay.show(buffer0, buffer1);
    }
    else
    {
        mydisplay.show("CALIBRATION", "START IN 3s ...");
        wait(1);
        mydisplay.show("CALIBRATION", "START IN 2s ...");
        wait(1);
        mydisplay.show("CALIBRATION", "START IN 1s ...");
        wait(1);
        mydisplay.show("CALIBRATION", "PHASE 1 ...");
        int32_t acc[3]={0}, gyr[3]={0};
        for(int i=0;i<100;i++)
        {
            int32_t acc_tmp[3]={0}, gyr_tmp[3]={0};
            accelerometer->Get_X_Axes(acc_tmp);
            gyroscope->Get_G_Axes(gyr_tmp);
            acc[0] += acc_tmp[0];
            acc[1] += acc_tmp[1];
            acc[2] += acc_tmp[2];
            gyr[0] += gyr_tmp[0];
            gyr[1] += gyr_tmp[1];
            gyr[2] += gyr_tmp[2];
            wait(0.02);
        }
        myrawdata.__gyr_offset[0]=-gyr[0]/100;
        myrawdata.__gyr_offset[1]=-gyr[1]/100;
        myrawdata.__gyr_offset[2]=-gyr[2]/100;
        myrawdata.__acc_offset[0]=-acc[0]/100;
        myrawdata.__acc_offset[1]=-acc[1]/100;
        myrawdata.__acc_offset[2]=1-acc[2]/100;  // gravaty
        
        mydisplay.show("CALIBRATION", "PHASE 2 ...");
        int32_t mag_max[3]={-10000}, mag_min[3]={10000};
        for(int i=0;i<500;i++)
        {
            int32_t mag_tmp[3]={0};
            magnetometer->Get_M_Axes(mag_tmp);
            mag_max[0]=mag_tmp[0]>mag_max[0]?mag_tmp[0]:mag_max[0];
            mag_max[1]=mag_tmp[1]>mag_max[1]?mag_tmp[1]:mag_max[1];
            mag_max[2]=mag_tmp[2]>mag_max[2]?mag_tmp[2]:mag_max[2];
            mag_min[0]=mag_tmp[0]<mag_min[0]?mag_tmp[0]:mag_min[0];
            mag_min[1]=mag_tmp[1]<mag_min[1]?mag_tmp[1]:mag_min[1];
            mag_min[2]=mag_tmp[2]<mag_min[2]?mag_tmp[2]:mag_min[2];
            wait(0.02);
        }
        myrawdata.__mag_offset[0]=-((mag_max[0]+mag_min[0])/2);
        myrawdata.__mag_offset[1]=-((mag_max[1]+mag_min[1])/2);
        myrawdata.__mag_offset[2]=-((mag_max[2]+mag_min[2])/2);
        
        mode=MODE_NORMAL;
    }
    
    // NEXT STATE
    if(mode==MODE_NORMAL)
    {
        if(fbtn==BTN_PRESSED_LONG)
        {
            mode=MODE_CONFIG;
        }
        else if(fbtn==BTN_PRESSED)
        {
            func=func+1;
            if(func>FUNC_ALTICDIR)
                func=FUNC_DATETIME;
        }
        else if(fbtn==BTN_PRESSED_VERY_LONG)
        {
            mode=MODE_CONFIG_AUTO;
        }
    }
    else if(mode==MODE_CONFIG)
    {
        if(fbtn==BTN_PRESSED_VERY_LONG)
        {
            config_index=0;
            mode=MODE_NORMAL;
        }
        else if(fbtn==BTN_PRESSED_LONG)
        {
            config_index+=1;
            if(func==FUNC_DATETIME){
                if(config_index>8)
                {
                    config_index=0;
                }
            } else if(func== FUNC_TEMPHUMI){
                if(config_index>6)
                {
                    config_index=0;
                }
            } else if(func==FUNC_ALTICDIR){
                if(config_index>3)
                {
                    config_index=0;
                }
            }
        }
        else if(fbtn==BTN_PRESSED)
        {
            if(func==FUNC_DATETIME)
            {
                if(config_index==0)
                {
                    myrawdata.add_year_10();
                }
                else if(config_index==1)
                {
                    myrawdata.add_year_1();
                }
                else if(config_index==2)
                {
                    myrawdata.add_month();
                }
                else if(config_index==3)
                {
                    myrawdata.add_day();
                }
                else if(config_index==4)
                {
                    myrawdata.add_hour();
                }
                else if(config_index==5)
                {
                    myrawdata.add_min_10();
                }
                else if(config_index==6)
                {
                    myrawdata.add_min_1();
                }
                else if(config_index==7)
                {
                    myrawdata.add_sec_10();
                }
                else if(config_index==8)
                {
                    myrawdata.add_sec_1();
                }
            }
            else if(func==FUNC_TEMPHUMI)
            {
                if(config_index==0)
                {
                    myrawdata.add_temp_sign();
                }
                else if(config_index==1)
                {
                    myrawdata.add_temp_10();
                }
                else if(config_index==2)
                {
                    myrawdata.add_temp_1();
                }
                else if(config_index==3)
                {
                    myrawdata.add_temp_1_10();
                }
                else if(config_index==4)
                {
                    myrawdata.add_humi_10();
                }
                else if(config_index==5)
                {
                    myrawdata.add_humi_1();
                }
                else if(config_index==6)
                {
                    myrawdata.add_humi_1_10();
                }
            }
            else if(func==FUNC_ALTICDIR)
            {
                if(config_index==0)
                {
                    myrawdata.add_altitude_1000();
                }
                else if(config_index==1)
                {
                    myrawdata.add_altitude_100();
                }
                else if(config_index==2)
                {
                    myrawdata.add_altitude_10();
                }
                else if(config_index==3)
                {
                    myrawdata.add_altitude_1();
                }
            }
        }
    }
    else
    {
        ;
    }
    
    wait_action();
}

/*  
raise_error(ERROR_CONFIG);

  printf("START CALIBRATION\n");
  int32_t m_max[3]={0};
  int32_t m_min[3]={0};
  for (int i=0; i<1000; i++)
  {
       
        magnetometer->Get_M_Axes(axes);
        if(i==0)
        {
            for(int j=0; j<3; j++)
            {
                m_max[j]=axes[j];
                m_min[j]=axes[j];
            }
        }
        else
        {
            for(int j=0; j<3; j++)
            {
                if(axes[j]>m_max[j])  m_max[j]=axes[j];
                if(axes[j]<m_min[j])  m_min[j]=axes[j];
            }
        }
        wait(0.05);
  }
  
  printf("MAX : %d, %d, %d\n", m_max[0], m_max[1], m_max[2]);
  printf("MIN : %d, %d, %d\n", m_min[0], m_min[1], m_min[2]);
  
 
  while(1) {
    if((mybutton!=0) && (button_mem==0))
    {
        func++;
        if(func>=6)
            func=0;
    }
    button_mem=mybutton;
    printf("func: %d\r\n", func);
    printf("\r\n");
    
    if(func==0)
    {
        time_t seconds = time(NULL);
        printf("Time as a basic string = %s\r\n", ctime(&seconds));
    }
    else if(func==1)
    {
    temp_sensor1->GetTemperature(&value1);
    humidity_sensor->GetHumidity(&value2);
    
    if(value2 > 70)
        myled=1;
    else
        myled=0;
    printf("HTS221: [temp] %7s C,   [hum] %s%%\r\n", printDouble(buffer1, value1), printDouble(buffer2, value2));
    }
    else if(func==2)
    {
    temp_sensor2->GetFahrenheit(&value1);
    pressure_sensor->GetPressure(&value2);
    printf("LPS25H: [temp] %7s F, [press] %smbar\r\n", printDouble(buffer1, value1), printDouble(buffer2, value2));
    printf("Altitude: %s m\r\n", printDouble(buffer1, 44300-44300*pow((value2/1013.25), 0.00019)));
    }
    else if(func==3)
    {
    magnetometer->Get_M_Axes(axes);
    axxx[0]=axes[0]-((m_max[0]+m_min[0])/2);
    axxx[1]=axes[1]-((m_max[1]+m_min[1])/2);
    axxx[2]=axes[2]-((m_max[2]+m_min[2])/2);
    printf("LIS3MDL [mag/mgauss]:  %6ld, %6ld, %6ld\r\n", axxx[0], axxx[1], axxx[2]);
    printf("DIR: %s deg\r\n", printDouble(buffer1, 90-atan(float(axxx[0])/float(axxx[1])/3.1416)));
    }
    else if(func==4)
    {
    accelerometer->Get_X_Axes(axes);
    printf("LSM6DS0 [acc/mg]:      %6ld, %6ld, %6ld\r\n", axes[0], axes[1], axes[2]);
    }
    else if(func==5)
    {
    gyroscope ->Get_G_Axes(axes);
    printf("LSM6DS0 [gyro/mdps]:   %6ld, %6ld, %6ld\r\n", axes[0], axes[1], axes[2]);
    }
    wait(1.5);
  }*/
  
}
