#include "mbed.h"

#ifndef __MAS_RAW_DATA_H__
#define __MAS_RAW_DATA_H__

class RawData
{
public:
    time_t __time;
    float __temp;               // unit : Degree Celsius
    float __humi;               // unit : %
    float __prss;           // unit : kPa
    int32_t __acc[3];           // unit : 
    int32_t __gyr[3];           // unit :
    int32_t __mag[3];           // unit :
    float __temp_offset;        // unit : Degree Celsius
    float __humi_offset;        // unit : %
    float __pressure_offset;
    float __altitude_offset;    // unit : m
    int32_t __acc_offset[3];    // unit :
    int32_t __gyr_offset[3];    // unit :
    int32_t __mag_offset[3];    // unit :
    
public:
    RawData();
    void add_year_10();
    void add_year_1();
    void add_month();
    void add_day();
    void add_hour();
    void add_min_10();
    void add_min_1();
    void add_sec_10();
    void add_sec_1();
    void add_temp_sign();
    void add_temp_10();
    void add_temp_1();
    void add_temp_1_10();
    void add_humi_10();
    void add_humi_1();
    void add_humi_1_10();
    void add_altitude_1();
    void add_altitude_10();
    void add_altitude_100();
    void add_altitude_1000();
    time_t calc_datetime();
    float calc_temperature();
    float calc_humidity();
    int32_t calc_altitude();
    int32_t calc_cpassdir();
    void str_date(char *buffer);
    void str_time(char *buffer);
    void str_temperature(char *buffer);
    void str_humidity(char *buffer);
    void str_pressure(char *buffer);
    void str_altitude(char *buffer);
    void str_magnetic(char *buffer);
    void str_direction(char *buffer);
    
private:
    char* printDouble(char* str, double v,int integerDigits=2, int decimalDigits=1);
};


#endif // __MAS_RAW_DATA_H__