#include "RawData.h"

char buffer2[32];
const uint32_t __pressure_table[16]={1013, 995, 976, 959, 942, 925, 908, 892, 875, 859, 843, 812, 782, 752, 724, 696};
const uint32_t __altitude_table[16]={0, 500, 1000, 1500, 2000, 2500, 3000, 3500, 4000, 4500, 5000, 6000, 7000, 8000, 9000, 10000};
const uint8_t __dir_table[5] = {'E', 'N', 'W', 'S', 'E'}; 

RawData::RawData()
{
    this->__temp_offset=0;
    this->__humi_offset=0;
    this->__pressure_offset=0;
    this->__altitude_offset=0;
    this->__acc_offset[0]=0;
    this->__acc_offset[1]=0;
    this->__acc_offset[2]=0;
    this->__gyr_offset[0]=0;
    this->__gyr_offset[1]=0;
    this->__gyr_offset[2]=0;
    this->__mag_offset[0]=0;
    this->__mag_offset[1]=0;
    this->__mag_offset[2]=0;
}

void RawData::str_date(char *buffer)
{
    struct tm *timeinfo = localtime (&(this->__time));
    strftime (buffer, 16, "%y-%m-%d", timeinfo);
}
void RawData::str_time(char *buffer)
{
    struct tm *timeinfo = localtime (&(this->__time));
    strftime (buffer, 16, "%T", timeinfo);
}
void RawData::str_temperature(char *buffer)
{
    if(this->calc_temperature()>=0)
        snprintf(buffer, 16, "T: %sC", this->printDouble(buffer2, (this->calc_temperature())));
    else
        snprintf(buffer, 16, "T:-%sC", this->printDouble(buffer2, -1*(this->calc_temperature())));
}
void RawData::str_humidity(char *buffer)
{
    if(this->calc_humidity()<100)
        snprintf(buffer, 16, "H: %sPer", this->printDouble(buffer2, (this->calc_humidity())));
    else
        snprintf(buffer, 16, "H: 00.0Per");
}
void RawData::str_altitude(char *buffer)
{
    snprintf(buffer, 16, "A: %4uM", this->calc_altitude());
}
void RawData::str_direction(char *buffer)
{
    uint32_t dir = this->calc_cpassdir();
    snprintf(buffer, 16, "D: %c%3uDeg", __dir_table[(dir+45)/90], dir);
}

char* RawData::printDouble(char* str, double v, int integerDigits, int decimalDigits)
{
  int i = 1;
  int intPart, fractPart;
  int len;
  char *ptr;

  /* prepare decimal digits multiplicator */
  for (;decimalDigits!=0; i*=10, decimalDigits--);

  /* calculate integer & fractinal parts */
  int powval=1;
  for(int xx=0; xx<integerDigits;xx++)
    powval = powval*10;
    
  if(integerDigits>0)
    intPart = (int)(v) % powval;
  else
    intPart = (int)(v);
  fractPart = (int)((v-(double)(int)v)*i);

  /* fill in integer part */
  sprintf(str, "%i.", intPart);

  /* prepare fill in of fractional part */
  len = strlen(str);
  ptr = &str[len];

  /* fill in leading fractional zeros */
  for (i/=10;i>1; i/=10, ptr++) {
    if(fractPart >= i) break;
    *ptr = '0';
  }

  /* fill in (rest of) fractional part */
  sprintf(ptr, "%i", fractPart);

  return str;
}


float RawData::calc_temperature()
{
    return this->__temp+this->__temp_offset;
}
float RawData::calc_humidity()
{
    return this->__humi+this->__humi_offset;
}
int32_t RawData::calc_altitude()
{
    uint32_t altitude=0;
    uint32_t bound_h=0, bound_l=16;
    float pressure = (this->__prss+this->__pressure_offset)/10;
    for(uint32_t i=0; i<16; i++)
    {
        if(__pressure_table[i]<= pressure)
        {
            bound_h=i;
            break;
        }
        bound_l=i;
    }
    if(bound_h==bound_l){
        this->__pressure_offset = __pressure_table[bound_l]-this->__prss;
        altitude = __altitude_table[bound_l];
    }else{
        altitude = __altitude_table[bound_l]+(__altitude_table[bound_h]-__altitude_table[bound_l])/double(__pressure_table[bound_l]-__pressure_table[bound_h])*(__pressure_table[bound_l]-pressure);
    }
    int32_t a=int32_t(altitude+__altitude_offset);
    return a;
}
int32_t RawData::calc_cpassdir()
{
    int32_t dir =0;
    float x = this->__mag[0]+this->__mag_offset[0];
    float y = this->__mag[1]+this->__mag_offset[1];
    if(y==0){
        if(x>=0)
            dir = 0;
        else
            dir = 180;
    }else if(y>0){
        dir = uint32_t(90-(atan(x/y))*180/3.14);
    }else{
        dir = uint32_t(270-(atan(x/y))*180/3.14);
    }
    return dir;
}







void RawData::add_year_10()
{
    struct tm *timeinfo = localtime (&(this->__time));
    int year= timeinfo->tm_year;
    year+=10;
    if(year>=(2100-1900))
        year=timeinfo->tm_year-90;
    timeinfo->tm_year=year;
    this->__time=mktime(timeinfo);
    set_time(this->__time);
}
void RawData::add_year_1()
{
    struct tm *timeinfo = localtime (&(this->__time));
    timeinfo->tm_year+=1;
    if(timeinfo->tm_year%10==0)
        timeinfo->tm_year-=10;
    this->__time=mktime(timeinfo);
    set_time(this->__time);
}
void RawData::add_month()
{
    struct tm *timeinfo = localtime (&(this->__time));
    int mon=timeinfo->tm_mon;
    mon+=1;
    if(mon>11)
        mon=0;
    timeinfo->tm_mon=mon;
    this->__time=mktime(timeinfo);
    set_time(this->__time);
}
void RawData::add_day()
{
    struct tm *timeinfo = localtime (&(this->__time));
    timeinfo->tm_yday=0;
    timeinfo->tm_wday=0;
    int day=timeinfo->tm_mday;
    day+=1;
    if(timeinfo->tm_mon==0 || timeinfo->tm_mon==2 || timeinfo->tm_mon==4 || timeinfo->tm_mon==6 || timeinfo->tm_mon==7 || timeinfo->tm_mon==9 || timeinfo->tm_mon==11)
    {
        if(day>31)
            day=1;
    }
    else if(timeinfo->tm_mon==1)
    {
        if((timeinfo->tm_year+1900)%400==0 || ((timeinfo->tm_year+1900)%100!=0 && (timeinfo->tm_year+1900)%4==0) )
        {
            if(day>29)
                day=1;
        }
        else
        {
            if(day>28)
                day=1;
        }
    }
    else
    {
        if(day>30)
            day=1;
    }
    timeinfo->tm_mday=day;
    this->__time=mktime(timeinfo);
    set_time(this->__time);
}
void RawData::add_hour()
{
    struct tm *timeinfo = localtime (&(this->__time));
    int hour=timeinfo->tm_hour;
    hour+=1;
    if(hour>23)
        hour=0;
    timeinfo->tm_hour=hour;
    this->__time=mktime(timeinfo);
    set_time(this->__time);
}
void RawData::add_min_10()
{
    struct tm *timeinfo = localtime (&(this->__time));
    int min=timeinfo->tm_min;
    min+=10;
    if(min>=60)
        min-=60;
    timeinfo->tm_min=min;
    this->__time=mktime(timeinfo);
    set_time(this->__time);
}
void RawData::add_min_1()
{
    struct tm *timeinfo = localtime (&(this->__time));
    int min=timeinfo->tm_min;
    min+=1;
    if(min%10==0)
        min-=10;
    timeinfo->tm_min=min;
    this->__time=mktime(timeinfo);
    set_time(this->__time);
}
void RawData::add_sec_10()
{
    struct tm *timeinfo = localtime (&(this->__time));
    int sec=timeinfo->tm_sec;
    sec+=10;
    if(sec>=60)
        sec-=60;
    timeinfo->tm_sec=sec;
    this->__time=mktime(timeinfo);
    set_time(this->__time);
}
void RawData::add_sec_1()
{
    struct tm *timeinfo = localtime (&(this->__time));
    int sec=timeinfo->tm_sec;
    sec+=1;
    if(sec%10==0)
       sec-=10;
    timeinfo->tm_sec=sec;
    this->__time=mktime(timeinfo);
    set_time(this->__time);
}
void RawData::add_temp_sign()
{
    this->__temp_offset= -1*(this->calc_temperature())-this->__temp;
}
void RawData::add_temp_10()
{
    float val = this->__temp_offset;
    if(this->__temp+val>=0)
        val+=10;
    else
        val-=10;
    if(this->__temp+val>=100)
        val-=100;
    else if(this->__temp+val<=-100)
        val+=100;
    this->__temp_offset=val;
}
void RawData::add_temp_1()
{
    float val= this->__temp_offset;
    if(this->__temp+val>=0)
        val+=1;
    else
        val-=1;
    if((this->__temp+val)>=0 && (int)(this->__temp+val)%10==0)
        val-=10;
    else if((this->__temp+val)<0 && (int)(this->__temp+val)%10==0)
        val+=10;
    this->__temp_offset=val;
}
void RawData::add_temp_1_10()
{
    float val=(this->__temp_offset*10);
    if(this->__temp*10+val>=0)
        val+=1;
    else
        val-=1;
    if(this->__temp*10+val>=0 && (int)(this->__temp*10+val)%10==0)
        val-=10;
    else if(this->__temp*10+val<0 && (int)(this->__temp*10+val)%10==0)
        val+=10;
    this->__temp_offset=val/10.0;
}
void RawData::add_humi_10()
{
    float val=this->__humi_offset;
    val+=10;
    if((int)(this->__humi+val)>=100)
        val-=100;
    this->__humi_offset=val;
}
void RawData::add_humi_1()
{
    float val=this->__humi_offset;
    int delta = (int)(this->__humi_offset);
    val = val-delta;
    delta+=1;
    if((int)(this->__humi+delta)%10==0)
        delta-=10;
    this->__humi_offset=val+delta;
}
void RawData::add_humi_1_10()
{
    int delta=(int)(this->__humi_offset*10);
    delta+=1;
    if((int)(this->__humi*10+delta)%10==0)
        delta-=10;
    this->__humi_offset=delta/10.0;
}

// ALTITUDE
void RawData::add_altitude_1000()
{
    this->__altitude_offset+=1000;
    if(this->calc_altitude()>=10000)
        this->__altitude_offset-=10000;
}
void RawData::add_altitude_100()
{
    this->__altitude_offset+=100;
    if((this->calc_altitude()/100)%10==0)
        this->__altitude_offset-=1000;
}
void RawData::add_altitude_10()
{
    this->__altitude_offset+=10;
    if((this->calc_altitude()/10)%10==0)
       this->__altitude_offset-=100;
}
void RawData::add_altitude_1()
{
    this->__altitude_offset+=1;
    if(this->calc_altitude()%10==0)
       this->__altitude_offset-=10;
}