#include "mbed.h"

#include "DHT.h"

#include "TCS3472_I2C.h"

//DigitalOut led(LED3);
Serial pc(USBTX, USBRX);

DHT dht(A1, 22);

TCS3472_I2C rgb_sensor( PB_4, PA_7 );

int main(){
    
    int data;
    rgb_sensor.enablePowerAndRGBC();
    rgb_sensor.setIntegrationTime(100);
    int rgb_readings[4];
    
    
    while(1){
        
        data = dht.readData();
        rgb_sensor.getAllColors(rgb_readings);
        //led = !led;
        if(data == ERROR_NONE){
            pc.printf("La temperature de la salle est: %.2f et Humidite est: %.2f\n", dht.ReadTemperature(CELCIUS), dht.ReadHumidity());
        }
        else{
            //pc.printf("Erreur numero: %d\n", data);
        }
        
        pc.printf( "red: %d, green: %d, blue: %d, clear: %d\n", rgb_readings[0], rgb_readings[1], rgb_readings[2], rgb_readings[3] );
        wait_ms(5000);
        
    }
}