#include "mbed.h"
#include "TM1637.h"

//      1
//   +-----+
//   |     |
// 32|     |2
//   |     |
//   + 64  +
//    +---+
//   +     +
//   |     |
// 16|     |4
//   |     |
//   +-----+
//      8
char digits[] = {63,6,91,79,102,109,125,7,127,111};


Serial pc(USBTX, USBRX);

TM1637::DisplayData_t all_str  = {0xFF, 0xFF, 0xFF, 0xFF};

TM1637_CATALEX CATALEX(PC_1, PC_0);


int main()
{
    CATALEX.cls(); 
    CATALEX.writeData(all_str);
    CATALEX.setBrightness(TM1637_BRT3);

    pc.printf("\n\r\n\r--HELLO--\n\r");

    int cnt=0;
    int num;
    char numdigits[4];
    while(1){
        num=cnt;
        int i=0;
        while(num != 0)
        {
            int digit = num % 10;
            num = num / 10;
            numdigits[i]=digit;
            i++;
        }
    
        TM1637::DisplayData_t dat = {digits[numdigits[3]],digits[numdigits[2]],digits[numdigits[1]],digits[numdigits[0]]};
        CATALEX.writeData(dat);
        pc.printf("%d\n\r",cnt);
        wait(0.1);
        cnt++;
    }
 
}