#include "mbed.h"
#include "uLCD_4DGL.h"
#include "SDFileSystem.h"
#include <string>
#include "GT511C3.hpp"

DigitalIn Up(p15);
DigitalIn Center(p16);
DigitalIn Left(p17);
DigitalIn Down(p18);
DigitalIn Right(p19);
uLCD_4DGL uLCD(p28, p27, p29); // create a global lcd object
Serial debug(USBTX,USBRX);
SDFileSystem sd(p5, p6, p7, p8, "sd");
GT511C3 finger(p9, p10);

// ************** CONST VARIABLE **************** //
// Size
const int screen_width = 18;
const int screen_height = 14;
const int packet_size = 498;
const int id_size = 5;
const int sid_size = 9;
const int group_size = 200;
// Wait Time
const float scr_switch_wait = 1;
const float wait_time = 0.04;

// File Name
const char * owner_id_file = "owner_id_file.txt";
const char * sid_file = "sid_file.txt";

// VARIABLE
char group_id[id_size];
char sid_temp[sid_size];
int this_session[group_size];

//FUNCTIONS: UI
void left_arrow();
void clear_line(int line);
void display_center(int line, char * text);
void display_menu(int line, char * text);
void start_program();
void SCR_start_session();
void SCR_header();
int is_authenticated();
int is_enroll_more();
int SCR_auth_to_enroll_new_fingerprint(char * msg);
void SCR_enroll_new_fingerprint();
void enter_int_input(char * to_put, int size, int x, int y);
int db_exists(char * group_idDB);
void close_session();
void FUNC_update_right_arrow(int * selection, int size, int start);
void read_from_fingerprint_scanner();
void upload_to_scanner();
string getstudentIDfromIndex(int fid);
void send_email();
int get_enroll_id(const char * filename, char * sid);
void enroll_new_fingerprint(char* groupIDF, char* index);
int progress(int status, char *msg);
void add_new_fingerprint();

int main() {
    while (1) {
        start_program();
    }
}

void start_program() {
    int is_done = 0;
    while (!is_done) {
        uLCD.cls();
        SCR_header();
        if (is_authenticated()) {
            SCR_start_session();
        }
    }
}

void SCR_start_session() {
    upload_to_scanner();
    int is_done = 0;
    int selection;
    while (!is_done) {
        uLCD.cls();
        display_center(1, "MENU");        
        display_menu(4, "Scan");
        display_menu(5, "Enroll");
        display_menu(6, "Close session");
        FUNC_update_right_arrow(&selection, 3, 4);
        if (selection == 0) {
            debug.printf("Entering read_from_fingerprint_scanner()\n");
            read_from_fingerprint_scanner();
        } else if (selection == 1) {
            debug.printf("Entering auth to enroll new()\n");
            if (SCR_auth_to_enroll_new_fingerprint("Enroll New")) {
                add_new_fingerprint();
            }
        } else if (selection == 2) {
            is_done = SCR_auth_to_enroll_new_fingerprint("Close Session");
            close_session();
        } else {
            uLCD.printf("YOW! NOT SUPPOSED TO GET HERE!");
        }
    }
}

void close_session() {
    // remove the current id
    // send information to the owner
    // make sure the database is updated
}

/*
 * Compare whether the currently scanned fingerprint is contained
 * in the existing database. Set the this_session_id data structure
 * to 1 if yes to notify that the person has signed in for this
 * session.
 *
 * @param none
 * @return none
 */
void read_from_fingerprint_scanner() {
    uLCD.cls();
    display_center(1, "SCAN");
    left_arrow();
    int FID = -1;
    
    //Talk to the fingerprint and get an ID back
    display_center(5, "Place finger");
    display_center(6, "on scanner!");
    finger.CmosLed(1);        
    finger.WaitPress(1);
    int is_cancelled = 0;
    while(finger.Capture(1) != 0 && !is_cancelled) {
        if (!Down) {
            is_cancelled = 1;
            finger.WaitPress(0);
            finger.CmosLed(0);
        }
    }
    clear_line(5);
    clear_line(6);
    
    if (!is_cancelled) {
        // Identify!
        FID = finger.Identify();
        
    //        debug.printf("ID = %d\n", FID);
        display_center(5, "Remove finger");
        display_center(6, "from scanner!");
        finger.WaitPress(0);
        finger.CmosLed(0);
        if(FID!=-1)
        {
            display_center(8, "Student found!");
           
            this_session[FID] = 1;
        } else {
            display_center(8, "Student not found");
        }
         wait(2);
        if (FID >= 0 && FID < group_size) {
        } else {
            debug.printf("Sorry, ID failed!");
        }
    }
}

void send_email() {
    string attended;
    //char buffer[2000];
    
    
//    attended = getstudentIDfromIndex(FID);
//    debug.printf("Attended = %s",attended);
    //allAttended = allAttended + "\n" + attended;
    //debug.printf("All Attended %s",allAttended);
}

void clear_line(int line) {
    uLCD.locate(0,line);
    uLCD.printf("                  ");
}

void upload_to_scanner() {
    finger.DeleteAllIDs();
   
    int indexScanner = 0;
     
    string fileNameScan;
    char indexC[3];
    sprintf(indexC,"%d",indexScanner);
    fileNameScan = "/sd/" + string(group_id) + "/" + indexC + ".bin";
    const char* conv_fileScan = fileNameScan.c_str();
    unsigned char data[packet_size];
//    debug.printf("Attempt to find file %s\n", conv_fileScan);
     
    FILE *templateFile = fopen(conv_fileScan, "r");
    if(templateFile==NULL) {
       debug.printf("File is NULL!\n");   
    }
     
    while(templateFile != NULL) {
        fread(data, sizeof(unsigned char), sizeof(data),templateFile);
        
        if(finger.SetTemplate(indexScanner,data,packet_size)) {
//            debug.printf("Attempt to find fileSetTemplate %s\n", conv_fileScan);
            indexScanner++;  
            fclose(templateFile); 
        }
//        debug.printf("Index Scanner = %d",indexScanner);
        string fileNameScan;
        char indexC[3];
        sprintf(indexC,"%d",indexScanner);
        fileNameScan = "/sd/" + string(group_id) + "/" + indexC + ".bin";
        conv_fileScan = fileNameScan.c_str();
     
        debug.printf("Attempt to find file %s\n", conv_fileScan);
     
        FILE *templateFile = fopen(conv_fileScan, "r");
        if(templateFile==NULL)
        {
            debug.printf("THERE IS NO FILE!\n");
            break;   
        }
    }
}

string getstudentIDfromIndex(int fid) {
    char* studentIDN;
    string fNSID = "/sd/" + string(group_id) + "/" + string(sid_file);
//    debug.printf("fnSID = %s\n",fNSID);
    const char* conv_fNSID = fNSID.c_str();
    FILE *templateFile = fopen(conv_fNSID, "r");
    if(templateFile == NULL)
    {
        debug.printf("Template File NULL!!\n");   
    }
    fid = 2*fid + 1;
    for (int i = 0; i < fid;i++)
    {
           fgets(studentIDN, 10, templateFile);
    }
    fclose(templateFile);
    debug.printf("studentIDN = %s\n",studentIDN);
    return string(studentIDN);
}

int SCR_auth_to_enroll_new_fingerprint(char * msg) {
    uLCD.cls();
    display_center(1, msg);
    display_center(7, "Enter Group ID:");
    char gid_temp[id_size];
    enter_int_input(gid_temp, id_size, 0, 8);
    if (strcmp(gid_temp, group_id) == 0) {
        display_center(11, "Success!");
        wait(scr_switch_wait);
        return 1;
    } else {
        display_center(11, "Failed!");
        wait(scr_switch_wait);
      return 0;
    }    
}
/**
 UI for the right arrow to choose which one of the options
 that is chosen.
 @param selection
 @param size
 @param start
 */
void FUNC_update_right_arrow(int * selection, int size, int start) {
    int x = 15;
    int y = start;
    uLCD.locate(x, y);
    uLCD.printf(">>");
    int is_entered = 0;
    while(!is_entered) {
        if (!Down) {
            uLCD.locate(x, y);
            uLCD.printf("  ");
            y++;
            if (y - start < 0) {
                y = start;
            } else if (y - start >= size) {
                y = size + start - 1;
            }
            uLCD.locate(x, y);
            uLCD.printf(">>");
        } else if(!Up) {
            uLCD.locate(x, y);
            uLCD.printf("  ");
            y--;
            if (y - start < 0) {
                y = start;
            } else if (y - start >= size) {
                y = size + start - 1;
            }
            uLCD.locate(x, y);
            uLCD.printf(">>");
        } else if(!Left) {
        } else if(!Right) {
            * selection = y - start;
            is_entered = 1;
        } else if (!Center) {
        }
        wait(wait_time);
    }    
}

void SCR_header() {
    uLCD.cls();
    uLCD.printf("******************\n");
    uLCD.printf("FingerprintScanner \n");
    uLCD.printf("******************\n\n");
}

int is_authenticated() {
    display_center(7, "Enter Group ID:");
    char gid_temp[id_size];
    enter_int_input(gid_temp, id_size, 0, 8);
    if (db_exists(gid_temp)) {
        memcpy(group_id, gid_temp, id_size);
        return 1;
    } else {
        return 0;
    }
}

/**
 Match the parameter whether it exists in
 owner_id_file
 @param group_id the string to be checked
 @return 1 if group_id is in owner_id_file, 0 otherwise
 */
int db_exists(char * group_idDB) {
    
    FILE *file = fopen("/sd/owner_id_file.txt", "r");
//    uLCD.printf("Opening file: %s\n",filename);
    char buffer[6];
    debug.printf("Finding database\n");
    if(file==NULL)
    {
        debug.printf("No File!\n");
    }
    while (fgets(buffer, 6, file))
    {
//        debug.printf("Buffer = %s\n",buffer);
//        debug.printf("Group iD = %s\n",group_id);
        if (strcmp(group_idDB,buffer)==0) {
            debug.printf("Found!\n");

            fclose(file);
            display_center(11, "Authenticated,");
            display_center(12, "session starts!");
            wait(scr_switch_wait);
            return 1;
        }
    }
    fclose(file);
    display_center(11, "Not authenticated");
    wait(scr_switch_wait);
    return 0;
}

void enter_int_input(char * to_put, int size, int x, int y) {
    x = (screen_width - size) / 2;
    int current = 0;
    int gid_int[size];
    for (int i = 0; i < size; i++) {
        gid_int[i] = 0;
    }
    int is_entered = 0;
    while(!is_entered) {
        for (int i = 0; i < size; i++) {
            uLCD.locate(x + i, y);
            uLCD.printf("%d", gid_int[i]);
        }
        if (!Down) {
            if (gid_int[current] == 0) {
                gid_int[current] += 10;
            }
            gid_int[current]--;
        } else if(!Up) {
            if (gid_int[current] == 9) {
                gid_int[current] = 0;
            } else {
                gid_int[current]++;
            }
        } else if(!Left) {
            current --;
        } else if(!Right) {
            current++;
        } else if (!Center) {
            for (int i = 0; i < size; i++) {
                sprintf((to_put + i), "%d", gid_int[i]);
            }
            is_entered = 1;
        }
        wait(wait_time);
        if (current < 0) {
            current = 0;
        } else if (current >= size) {
            current = size - 1;
        }
    }
}

void left_arrow() {
    uLCD.locate(1,1);
    uLCD.printf("<<");
}

void add_new_fingerprint() {
   
   string fileNameSID;
   int cancelled = 0;
   
   do {
        uLCD.cls();
        display_center(1, "ENROLL");
        display_center(5, "Enter SID:");
        char student_id[sid_size];
        enter_int_input(student_id, sid_size, 0, 6);
//        uLCD.printf("\n\nStudent Id = %s\n",student_id);
        wait(wait_time);
        fileNameSID = "/sd/" + string(group_id) + "/" + string(sid_file);
    //           uLCD.printf("Group ID 1 = %s\n",group_id);
        const char* conv_fileSID = fileNameSID.c_str();
    //           uLCD.printf("FileNameSID File = %s\n",fileNameSID);           
    //           uLCD.printf("Conv_fileSID = %s\n",conv_fileSID);
       
        int eid = get_enroll_id(conv_fileSID, student_id);
        if (eid == -1) {
            display_center(11, "Failed");
            uLCD.printf("\n\nEnroll Failed!\n");
        } else {
            
            char eidc[4];
            sprintf(eidc, "%d",eid);
           
//            uLCD.printf("Enroll ID = %s\n",eidc);
            enroll_new_fingerprint(group_id, eidc);
//            uLCD.printf("\n\nSuccess\n");
            display_center(11, "Succeeded");
        }
        wait(1);
        cancelled = is_enroll_more();
        wait(2);
    } while(!cancelled);
}

int is_enroll_more() {
    uLCD.cls();
    display_center(1, "MENU");
    display_center(3, "Enroll more?");
    display_menu(5, "Yes");
    display_menu(6, "No");
    int selection;
    FUNC_update_right_arrow(&selection, 2, 5);
    return selection;
}

void display_center(int line, char * text) {
    int len = strlen(text) - 1;
    int x = (screen_width - len) / 2;
    uLCD.locate(x, line);
    uLCD.printf(text);
}

void display_menu(int line, char * text) {
    int x = 1;
    uLCD.locate(x, line);
    uLCD.printf(text);
}

int get_enroll_id(const char * filename, char * sid) {

    debug.printf("GetEnrollID File %s\n",filename);
    FILE *file = fopen(filename, "r");
    if(file==NULL)
    {
        debug.printf("File NULL\n");
    }
    int index = 0;
    int is_found = 0;
    char buffer[10];
    while (fgets(buffer, 10, file))
    {
        debug.printf("A\n");
        debug.printf("Buffer = %s\n",buffer);
        debug.printf("SID = %s\n",sid);
        if (strcmp(buffer,sid) == 0)
        {
            debug.printf("Found at index %d!",index);
            uLCD.locate(1,9);
            uLCD.printf("Student ID found!\n");
            uLCD.printf("Scan Finger 3X !\n");
            fclose(file);
            is_found = 1;
            break;   
        }
        index++;    
    }    
    fclose(file);
    if(!is_found) {
        return -1;
        debug.printf("Invalid ID!");
    } else {
        return index/2; 
    }  
}

/*
 * Enroll new fingerprint into the existing class session
 *
 * @param 
 * @return none
 */
void enroll_new_fingerprint(char* groupIDF, char* index) {
//    uLCD.printf("Pick student ID :\n");
//    char SID[10] = "903091468";
//    char* index = "3";
    int EnrollID = -1;
    
    unsigned char datas[498];
    debug.printf("Trying to Enroll\n");
    finger.Enroll(EnrollID, progress);
    
    finger.RecvData(datas, 498);
    debug.printf("Index = %s, Int Index = %d",index, atoi(index));
   // int indexINT;
    
    finger.SetTemplate(atoi(index),datas,packet_size);
//    uLCD.printf("RecvData = %d\n", finger.RecvData(data, packet_size));
    string fileName;
    fileName = "/sd/" + string(groupIDF) + "/" + string(index) + ".bin";
    
    const char* conv_file = fileName.c_str();
    debug.printf("Trying to read file %s\n",conv_file);
    // make_bin_file(directory, groupID, index, fileName);
//    uLCD.printf("Trying to read file %s\n",fileName);
    
//    char* file = fileName;
    FILE *templateFile = fopen(conv_file, "w");
    
    if(templateFile == NULL) {
             debug.printf("Could not open file for write\n");
        }
    
    fwrite(datas,sizeof(unsigned char), sizeof(datas),templateFile);

    fclose(templateFile); 
 
 
    finger.CmosLed(1);
}

int progress(int status, char *msg) {
//    uLCD.locate(1,10);
    debug.printf("%s",msg);
    return 0;
}