#include "tHIH6130.h"

tHIH6130::tHIH6130(unsigned char aAdrHIH,I2C* apI2c)
{
    pI2c = apI2c;
    WrAdr = ((aAdrHIH)<<1) & 0xFE ;
    RdAdr = WrAdr | 0x01;
    
    
}


float   tHIH6130::getTemp(void)
{
    return Temp;
}



float   tHIH6130::getHumi(void)
{
    return Humi;
}
    
int     tHIH6130::StartMesure(void)
{
    int Res;
    pI2c->start();
    Res = pI2c->write(WrAdr);
    pI2c->stop();
    
    return Res;
}
    
int     tHIH6130::UpdateData(void)
{
    int Res;
    unsigned char   Data[4];
    unsigned int    Tmp;
    
    Res = pI2c->read(RdAdr,(char*)Data,4);
    
    // MAJ Humidité
    Tmp = Data[0] & 0x3F;
    Tmp <<= 8;
    Tmp += Data[1];
    
    Humi = ((float)Tmp / (float)16383)*float(100); 
    
    
    // MAJ Température
    Tmp = Data[2];
    Tmp <<= 8;
    Tmp += (Data[3] & 0xFC);
    Tmp >>=2;
    
    Temp = ((float)Tmp / (float)16383)*(float)165;
    Temp -= 40;
    
    return Res;
}
    
    


    
