#include "mbed.h"
#define wt 0.1

I2C i2c(p9, p10);        // sda, scl
Serial pc(USBTX, USBRX); 


#define addr 0x3c
char cmd[2];



void init_compass(){

    cmd[0] = 0x02;
    cmd[1] = 0x00;
    i2c.write(addr, cmd, 2);
}

long int x_get() {
    char data[1];
    //char cmd[2];
    int data_buff[2];
    short int buff;
    
    
    cmd[0] = 0x03;
    i2c.write(addr, cmd, 1);
    wait(wt);
    i2c.read(addr, data,1);
    data_buff[0] = data[0];
    wait(wt);
    
    cmd[0] = 0x04;
    i2c.write(addr, cmd, 1);
    wait(wt);
    i2c.read(addr, data, 1);
    data_buff[1] = data[0];
    
    buff = data_buff[0] << 8;
    buff = data_buff[1] | buff; 
    /* if (buff & 0x00 == 0xff00){
        buff = buff - 0x80;
        buff = buff * -1;
    }*/
    return buff;
}

long int z_get() {
    char data[1];
    int data_buff[2];
    short int buff;
    
    
    cmd[0] = 0x05;
    i2c.write(addr, cmd, 1);
    wait(wt);
    i2c.read(addr, data,1);
    data_buff[0] = data[0];
    wait(wt);
    
    cmd[0] = 0x06;
    i2c.write(addr, cmd, 1);
    wait(wt);
    i2c.read(addr, data, 1);
    data_buff[1] = data[0];
    
    buff = data_buff[0] << 8;
    buff = data_buff[1] | buff;

    return buff;
}

long int y_get() {
    char data[1];
    char data_buff[2];
    short int buff;
    
    
    cmd[0] = 0x07;
    i2c.write(addr, cmd, 1);
    wait(wt);
    i2c.read(addr, data,1);
    data_buff[0] = data[0];
    wait(wt);
    
    cmd[0] = 0x08;
    i2c.write(addr, cmd, 1);
    wait(wt);
    i2c.read(addr, data, 1);
    data_buff[1] = data[0];
    
    buff = data_buff[0] << 8;
    buff = data_buff[1] | buff;    

    return buff;
}
         
int main() {
init_compass();
    while(1) {
        pc.printf("%d/ %d/ %d\r\n", x_get(), y_get(), z_get());
        wait(0);
    }
}