#include <nap.hpp>

NAP::NAP(float nap_time):nap_time_(nap_time){
    restart();
}

void NAP::take_a_nap(){
    while((now_time - prev_time) < (nap_time_*1000)){
        now_time = nap.read_ms();
    }
    prev_time = now_time;
    if(prev_time > 18000000){
        now_time  = 0;
        prev_time = 0;
        nap.reset();
        nap.start();    
    }
}

void NAP::setNaptime(float nap_time){
    nap_time_ = nap_time;    
}

void NAP::restart(){
    nap.reset();
    nap.start();
    now_time = 0;
    prev_time = 0;    
}
